/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.job.JobHandle;
import org.apache.gravitino.meta.AuditInfo;

public class JobEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique id of the job entity.");
    public static final Field JOB_EXECUTION_ID = Field.required("job_execution_id", String.class, "The unique execution id of the job, used for tracking.");
    public static final Field STATUS = Field.required("status", JobHandle.Status.class, "The status of the job.");
    public static final Field TEMPLATE_NAME = Field.required("job_template_name", String.class, "The name of the job template.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the job template entity.");
    public static final Field FINISHED_AT = Field.optional("job_finished_at", Long.class, "The time when the job finished execution.");
    private Long id;
    private String jobExecutionId;
    private JobHandle.Status status;
    private String jobTemplateName;
    private Namespace namespace;
    private AuditInfo auditInfo;
    private Long finishedAt;

    private JobEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(JOB_EXECUTION_ID, this.jobExecutionId);
        fields.put(TEMPLATE_NAME, this.jobTemplateName);
        fields.put(STATUS, this.status);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(FINISHED_AT, this.finishedAt);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public Long id() {
        return this.id;
    }

    public String jobExecutionId() {
        return this.jobExecutionId;
    }

    @Override
    public String name() {
        return "job-" + this.id;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public JobHandle.Status status() {
        return this.status;
    }

    public String jobTemplateName() {
        return this.jobTemplateName;
    }

    public Long finishedAt() {
        return this.finishedAt;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.JOB;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobEntity)) {
            return false;
        }
        JobEntity that = (JobEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobExecutionId, that.jobExecutionId) && Objects.equals(this.status, that.status) && Objects.equals(this.jobTemplateName, that.jobTemplateName) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.auditInfo, that.auditInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobExecutionId, this.namespace, this.status, this.jobTemplateName, this.auditInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "JobEntity(id=" + this.id + ", jobExecutionId=" + this.jobExecutionId + ", status=" + String.valueOf(this.status) + ", jobTemplateName=" + this.jobTemplateName + ", namespace=" + String.valueOf(this.namespace) + ", auditInfo=" + String.valueOf(this.auditInfo) + ", finishedAt=" + this.finishedAt + ")";
    }

    public static class Builder {
        private final JobEntity jobEntity = new JobEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.jobEntity.id = id;
            return this;
        }

        public Builder withJobExecutionId(String jobExecutionId) {
            this.jobEntity.jobExecutionId = jobExecutionId;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.jobEntity.namespace = namespace;
            return this;
        }

        public Builder withStatus(JobHandle.Status status) {
            this.jobEntity.status = status;
            return this;
        }

        public Builder withJobTemplateName(String jobTemplateName) {
            this.jobEntity.jobTemplateName = jobTemplateName;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.jobEntity.auditInfo = auditInfo;
            return this;
        }

        public Builder withFinishedAt(Long finishedAt) {
            this.jobEntity.finishedAt = finishedAt;
            return this;
        }

        public JobEntity build() {
            this.jobEntity.validate();
            return this.jobEntity;
        }
    }
}

