/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.hive.pool.CachedClientPool;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.TimeUtils;
import org.apache.thrift.TException;

public class HiveCatalogLock
implements CatalogLock {
    static final String LOCK_IDENTIFIER = "hive";
    private final ClientPool<IMetaStoreClient, TException> clients;
    private final long checkMaxSleep;
    private final long acquireTimeout;

    public HiveCatalogLock(ClientPool<IMetaStoreClient, TException> clients, long checkMaxSleep, long acquireTimeout) {
        this.clients = clients;
        this.checkMaxSleep = checkMaxSleep;
        this.acquireTimeout = acquireTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithLock(String database, String table, Callable<T> callable) throws Exception {
        long lockId = this.lock(database, table);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.unlock(lockId);
        }
    }

    private long lock(String database, String table) throws UnknownHostException, TException, InterruptedException {
        LockComponent lockComponent = new LockComponent(LockType.EXCLUSIVE, LockLevel.TABLE, database);
        lockComponent.setTablename(table);
        lockComponent.unsetOperationType();
        LockRequest lockRequest = new LockRequest(Collections.singletonList(lockComponent), System.getProperty("user.name"), InetAddress.getLocalHost().getHostName());
        LockResponse lockResponse = (LockResponse)this.clients.run(client -> client.lock(lockRequest));
        long nextSleep = 50L;
        long startRetry = System.currentTimeMillis();
        while (lockResponse.getState() == LockState.WAITING) {
            if ((nextSleep *= 2L) > this.checkMaxSleep) {
                nextSleep = this.checkMaxSleep;
            }
            Thread.sleep(nextSleep);
            LockResponse tempLockResponse = lockResponse;
            lockResponse = (LockResponse)this.clients.run(client -> client.checkLock(tempLockResponse.getLockid()));
            if (System.currentTimeMillis() - startRetry <= this.acquireTimeout) continue;
            break;
        }
        long retryDuration = System.currentTimeMillis() - startRetry;
        if (lockResponse.getState() != LockState.ACQUIRED) {
            if (lockResponse.getState() == LockState.WAITING) {
                LockResponse tempLockResponse = lockResponse;
                this.clients.execute(client -> client.unlock(tempLockResponse.getLockid()));
            }
            throw new RuntimeException("Acquire lock failed with time: " + Duration.ofMillis(retryDuration));
        }
        return lockResponse.getLockid();
    }

    private void unlock(long lockId) throws TException, InterruptedException {
        this.clients.execute(client -> client.unlock(lockId));
    }

    public void close() {
    }

    public static ClientPool<IMetaStoreClient, TException> createClients(HiveConf conf, Options options, String clientClassName) {
        return new CachedClientPool((Configuration)conf, options, clientClassName);
    }

    public static long checkMaxSleep(HiveConf conf) {
        return TimeUtils.parseDuration((String)conf.get(CatalogOptions.LOCK_CHECK_MAX_SLEEP.key(), TimeUtils.getStringInMillis((Duration)((Duration)CatalogOptions.LOCK_CHECK_MAX_SLEEP.defaultValue())))).toMillis();
    }

    public static long acquireTimeout(HiveConf conf) {
        return TimeUtils.parseDuration((String)conf.get(CatalogOptions.LOCK_ACQUIRE_TIMEOUT.key(), TimeUtils.getStringInMillis((Duration)((Duration)CatalogOptions.LOCK_ACQUIRE_TIMEOUT.defaultValue())))).toMillis();
    }
}

