/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.wal.MetricsEditsReplaySource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsEditsReplaySourceImpl
extends BaseSourceImpl
implements MetricsEditsReplaySource {
    private static final Log LOG = LogFactory.getLog((String)MetricsEditsReplaySourceImpl.class.getName());
    private MetricHistogram replayTimeHisto;
    private MetricHistogram replayBatchSizeHisto;
    private MetricHistogram replayDataSizeHisto;

    public MetricsEditsReplaySourceImpl() {
        this("replay", "Metrics about HBase RegionServer WAL Edits Replay", "regionserver", "RegionServer,sub=replay");
    }

    public MetricsEditsReplaySourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.replayTimeHisto = this.metricsRegistry.newTimeHistogram("replayTime", "Time an replay operation took.");
        this.replayBatchSizeHisto = this.metricsRegistry.newSizeHistogram("replayBatchSize", "Number of changes in each replay batch.");
        this.replayDataSizeHisto = this.metricsRegistry.newSizeHistogram("replayDataSize", "Size (in bytes) of the data of each replay.");
    }

    public void updateReplayTime(long time) {
        this.replayTimeHisto.add(time);
    }

    public void updateReplayBatchSize(long size) {
        this.replayBatchSizeHisto.add(size);
    }

    public void updateReplayDataSize(long size) {
        this.replayDataSizeHisto.add(size);
    }
}

