/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.authorization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.dto.authorization.PrivilegeDTO;

public class SecurableObjectDTO
implements SecurableObject {
    @JsonProperty(value="type")
    private MetadataObject.Type type;
    @JsonProperty(value="privileges")
    private PrivilegeDTO[] privileges;
    private String parent;
    private String name;

    protected SecurableObjectDTO() {
    }

    @JsonProperty(value="fullName")
    public String getFullName() {
        return this.fullName();
    }

    @JsonProperty(value="fullName")
    public void setFullName(String fullName) {
        int index = fullName.lastIndexOf(".");
        if (index == -1) {
            this.parent = null;
            this.name = fullName;
        } else {
            this.parent = fullName.substring(0, index);
            this.name = fullName.substring(index + 1);
        }
    }

    @Nullable
    public String parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public MetadataObject.Type type() {
        return this.type;
    }

    public List<Privilege> privileges() {
        if (this.privileges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.privileges));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SecurableObjectDTO securableObjectDTO = new SecurableObjectDTO();
        private String fullName;
        private MetadataObject.Type type;
        private PrivilegeDTO[] privileges;

        private Builder() {
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withType(MetadataObject.Type type) {
            this.type = type;
            return this;
        }

        public Builder withPrivileges(PrivilegeDTO[] privileges) {
            this.privileges = privileges;
            return this;
        }

        public SecurableObjectDTO build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.fullName), (Object)"full name cannot be null or empty");
            Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"type cannot be null");
            Preconditions.checkArgument((this.privileges != null && this.privileges.length != 0 ? 1 : 0) != 0, (Object)"privileges can't be null or empty");
            this.securableObjectDTO.type = this.type;
            this.securableObjectDTO.privileges = this.privileges;
            this.securableObjectDTO.setFullName(this.fullName);
            return this.securableObjectDTO;
        }
    }
}

