/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.ByteBufferTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.SettableTimestamp;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class CellUtil {
    private CellUtil() {
    }

    @Deprecated
    public static ByteRange fillRowRange(Cell cell, ByteRange range) {
        return range.set(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    @Deprecated
    public static ByteRange fillFamilyRange(Cell cell, ByteRange range) {
        return range.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
    }

    @Deprecated
    public static ByteRange fillQualifierRange(Cell cell, ByteRange range) {
        return range.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    @Deprecated
    public static ByteRange fillValueRange(Cell cell, ByteRange range) {
        return range.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    @Deprecated
    public static ByteRange fillTagRange(Cell cell, ByteRange range) {
        return range.set(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
    }

    public static byte[] cloneRow(Cell cell) {
        byte[] output = new byte[cell.getRowLength()];
        CellUtil.copyRowTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneFamily(Cell cell) {
        byte[] output = new byte[cell.getFamilyLength()];
        CellUtil.copyFamilyTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneQualifier(Cell cell) {
        byte[] output = new byte[cell.getQualifierLength()];
        CellUtil.copyQualifierTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneValue(Cell cell) {
        byte[] output = new byte[cell.getValueLength()];
        CellUtil.copyValueTo(cell, output, 0);
        return output;
    }

    @Deprecated
    public static byte[] cloneTags(Cell cell) {
        byte[] output = new byte[cell.getTagsLength()];
        PrivateCellUtil.copyTagsTo(cell, output, 0);
        return output;
    }

    @Deprecated
    public static byte[] getTagArray(Cell cell) {
        byte[] output = new byte[cell.getTagsLength()];
        PrivateCellUtil.copyTagsTo(cell, output, 0);
        return output;
    }

    public static byte[] makeColumn(byte[] family, byte[] qualifier) {
        return Bytes.add(family, KeyValue.COLUMN_FAMILY_DELIM_ARRAY, qualifier);
    }

    public static byte[][] parseColumn(byte[] c) {
        int index = KeyValue.getDelimiter(c, 0, c.length, 58);
        if (index == -1) {
            return new byte[][]{c};
        }
        if (index == c.length - 1) {
            byte[] family = new byte[c.length - 1];
            System.arraycopy(c, 0, family, 0, family.length);
            return new byte[][]{family, HConstants.EMPTY_BYTE_ARRAY};
        }
        byte[][] result = new byte[2][];
        result[0] = new byte[index];
        System.arraycopy(c, 0, result[0], 0, index);
        int len = c.length - (index + 1);
        result[1] = new byte[len];
        System.arraycopy(c, index + 1, result[1], 0, len);
        return result;
    }

    public static int copyRowTo(Cell cell, byte[] destination, int destinationOffset) {
        short rowLen = cell.getRowLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), destinationOffset, rowLen);
        } else {
            System.arraycopy(cell.getRowArray(), cell.getRowOffset(), destination, destinationOffset, rowLen);
        }
        return destinationOffset + rowLen;
    }

    public static int copyRowTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        short rowLen = cell.getRowLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getRowByteBuffer(), destination, ((ByteBufferCell)cell).getRowPosition(), destinationOffset, rowLen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getRowArray(), cell.getRowOffset(), rowLen);
        }
        return destinationOffset + rowLen;
    }

    public static byte[] copyRow(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return ByteBufferUtils.copyOfRange(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), ((ByteBufferCell)cell).getRowPosition() + cell.getRowLength());
        }
        return Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
    }

    public static int copyFamilyTo(Cell cell, byte[] destination, int destinationOffset) {
        byte fLen = cell.getFamilyLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), destinationOffset, fLen);
        } else {
            System.arraycopy(cell.getFamilyArray(), cell.getFamilyOffset(), destination, destinationOffset, fLen);
        }
        return destinationOffset + fLen;
    }

    public static int copyFamilyTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        byte fLen = cell.getFamilyLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getFamilyByteBuffer(), destination, ((ByteBufferCell)cell).getFamilyPosition(), destinationOffset, fLen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
        }
        return destinationOffset + fLen;
    }

    public static int copyQualifierTo(Cell cell, byte[] destination, int destinationOffset) {
        int qlen = cell.getQualifierLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), destinationOffset, qlen);
        } else {
            System.arraycopy(cell.getQualifierArray(), cell.getQualifierOffset(), destination, destinationOffset, qlen);
        }
        return destinationOffset + qlen;
    }

    public static int copyQualifierTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int qlen = cell.getQualifierLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getQualifierByteBuffer(), destination, ((ByteBufferCell)cell).getQualifierPosition(), destinationOffset, qlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getQualifierArray(), cell.getQualifierOffset(), qlen);
        }
        return destinationOffset + qlen;
    }

    public static int copyValueTo(Cell cell, byte[] destination, int destinationOffset) {
        int vlen = cell.getValueLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getValueByteBuffer(), ((ByteBufferCell)cell).getValuePosition(), destinationOffset, vlen);
        } else {
            System.arraycopy(cell.getValueArray(), cell.getValueOffset(), destination, destinationOffset, vlen);
        }
        return destinationOffset + vlen;
    }

    public static int copyValueTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int vlen = cell.getValueLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getValueByteBuffer(), destination, ((ByteBufferCell)cell).getValuePosition(), destinationOffset, vlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getValueArray(), cell.getValueOffset(), vlen);
        }
        return destinationOffset + vlen;
    }

    @Deprecated
    public static int copyTagTo(Cell cell, byte[] destination, int destinationOffset) {
        int tlen = cell.getTagsLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getTagsByteBuffer(), ((ByteBufferCell)cell).getTagsPosition(), destinationOffset, tlen);
        } else {
            System.arraycopy(cell.getTagsArray(), cell.getTagsOffset(), destination, destinationOffset, tlen);
        }
        return destinationOffset + tlen;
    }

    @Deprecated
    public static int copyTagTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int tlen = cell.getTagsLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getTagsByteBuffer(), destination, ((ByteBufferCell)cell).getTagsPosition(), destinationOffset, tlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getTagsArray(), cell.getTagsOffset(), tlen);
        }
        return destinationOffset + tlen;
    }

    @InterfaceAudience.Private
    @Deprecated
    public static byte getRowByte(Cell cell, int index) {
        if (cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)cell).getRowByteBuffer().get(((ByteBufferCell)cell).getRowPosition() + index);
        }
        return cell.getRowArray()[cell.getRowOffset() + index];
    }

    @Deprecated
    public static ByteBuffer getValueBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        return buffer;
    }

    @Deprecated
    public static ByteBuffer getQualifierBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        return buffer;
    }

    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value) {
        return ExtendedCellBuilderFactory.create(CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setTimestamp(timestamp).setType(type).setValue(value).build();
    }

    @Deprecated
    public static Cell createCell(byte[] rowArray, int rowOffset, int rowLength, byte[] familyArray, int familyOffset, int familyLength, byte[] qualifierArray, int qualifierOffset, int qualifierLength) {
        return ExtendedCellBuilderFactory.create(CellBuilderType.DEEP_COPY).setRow(rowArray, rowOffset, rowLength).setFamily(familyArray, familyOffset, familyLength).setQualifier(qualifierArray, qualifierOffset, qualifierLength).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length).build();
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value, long memstoreTS) {
        return CellUtil.createCell(row, family, qualifier, timestamp, type, value, null, memstoreTS);
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value, byte[] tags, long memstoreTS) {
        return ExtendedCellBuilderFactory.create(CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setTimestamp(timestamp).setType(type).setValue(value).setTags(tags).setSequenceId(memstoreTS).build();
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, KeyValue.Type type, byte[] value, byte[] tags) {
        return CellUtil.createCell(row, family, qualifier, timestamp, type.getCode(), value, tags, 0L);
    }

    @Deprecated
    public static Cell createCell(byte[] row) {
        return CellUtil.createCell(row, HConstants.EMPTY_BYTE_ARRAY);
    }

    @Deprecated
    public static Cell createCell(byte[] row, byte[] value) {
        return CellUtil.createCell(row, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, Long.MAX_VALUE, KeyValue.Type.Maximum.getCode(), value);
    }

    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier) {
        return CellUtil.createCell(row, family, qualifier, Long.MAX_VALUE, KeyValue.Type.Maximum.getCode(), HConstants.EMPTY_BYTE_ARRAY);
    }

    @Deprecated
    public static Cell createCell(Cell cell, List<Tag> tags) {
        return CellUtil.createCell(cell, TagUtil.fromList(tags));
    }

    @Deprecated
    public static Cell createCell(Cell cell, byte[] tags) {
        if (cell instanceof ByteBufferCell) {
            return new PrivateCellUtil.TagRewriteByteBufferCell((ByteBufferCell)cell, tags);
        }
        return new PrivateCellUtil.TagRewriteCell(cell, tags);
    }

    @Deprecated
    public static Cell createCell(Cell cell, byte[] value, byte[] tags) {
        if (cell instanceof ByteBufferCell) {
            return new PrivateCellUtil.ValueAndTagRewriteByteBufferCell((ByteBufferCell)cell, value, tags);
        }
        return new PrivateCellUtil.ValueAndTagRewriteCell(cell, value, tags);
    }

    public static CellScanner createCellScanner(final List<? extends CellScannable> cellScannerables) {
        return new CellScanner(){
            private final Iterator<? extends CellScannable> iterator;
            private CellScanner cellScanner;
            {
                this.iterator = cellScannerables.iterator();
                this.cellScanner = null;
            }

            @Override
            public Cell current() {
                return this.cellScanner != null ? this.cellScanner.current() : null;
            }

            @Override
            public boolean advance() throws IOException {
                while (true) {
                    if (this.cellScanner == null) {
                        if (!this.iterator.hasNext()) {
                            return false;
                        }
                        this.cellScanner = this.iterator.next().cellScanner();
                    }
                    if (this.cellScanner.advance()) {
                        return true;
                    }
                    this.cellScanner = null;
                }
            }
        };
    }

    public static CellScanner createCellScanner(Iterable<Cell> cellIterable) {
        if (cellIterable == null) {
            return null;
        }
        return CellUtil.createCellScanner(cellIterable.iterator());
    }

    public static CellScanner createCellScanner(final Iterator<Cell> cells) {
        if (cells == null) {
            return null;
        }
        return new CellScanner(){
            private final Iterator<Cell> iterator;
            private Cell current;
            {
                this.iterator = cells;
                this.current = null;
            }

            @Override
            public Cell current() {
                return this.current;
            }

            @Override
            public boolean advance() {
                boolean hasNext = this.iterator.hasNext();
                this.current = hasNext ? this.iterator.next() : null;
                return hasNext;
            }
        };
    }

    public static CellScanner createCellScanner(final Cell[] cellArray) {
        return new CellScanner(){
            private final Cell[] cells;
            private int index;
            {
                this.cells = cellArray;
                this.index = -1;
            }

            @Override
            public Cell current() {
                if (this.cells == null) {
                    return null;
                }
                return this.index < 0 ? null : this.cells[this.index];
            }

            @Override
            public boolean advance() {
                if (this.cells == null) {
                    return false;
                }
                return ++this.index < this.cells.length;
            }
        };
    }

    public static CellScanner createCellScanner(final NavigableMap<byte[], List<Cell>> map) {
        return new CellScanner(){
            private final Iterator<Map.Entry<byte[], List<Cell>>> entries;
            private Iterator<Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = map.entrySet().iterator();
                this.currentIterator = null;
            }

            @Override
            public Cell current() {
                return this.currentCell;
            }

            @Override
            public boolean advance() {
                while (true) {
                    if (this.currentIterator == null) {
                        if (!this.entries.hasNext()) {
                            return false;
                        }
                        this.currentIterator = this.entries.next().getValue().iterator();
                    }
                    if (this.currentIterator.hasNext()) {
                        this.currentCell = this.currentIterator.next();
                        return true;
                    }
                    this.currentCell = null;
                    this.currentIterator = null;
                }
            }
        };
    }

    @Deprecated
    public static boolean matchingRow(Cell left, Cell right) {
        return CellUtil.matchingRows(left, right);
    }

    @Deprecated
    public static boolean matchingRow(Cell left, byte[] buf) {
        return CellUtil.matchingRows(left, buf);
    }

    public static boolean matchingRows(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getRowLength() == 0;
        }
        return PrivateCellUtil.matchingRows(left, buf, 0, buf.length);
    }

    @Deprecated
    public static boolean matchingRow(Cell left, byte[] buf, int offset, int length) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)left.getRowLength(), buf, offset, length);
        }
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), left.getRowLength(), buf, offset, length);
    }

    public static boolean matchingFamily(Cell left, Cell right) {
        byte lfamlength = left.getFamilyLength();
        byte rfamlength = right.getFamilyLength();
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)lfamlength, ((ByteBufferCell)right).getFamilyByteBuffer(), ((ByteBufferCell)right).getFamilyPosition(), (int)rfamlength);
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)lfamlength, right.getFamilyArray(), right.getFamilyOffset(), (int)rfamlength);
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)right).getFamilyByteBuffer(), ((ByteBufferCell)right).getFamilyPosition(), (int)rfamlength, left.getFamilyArray(), left.getFamilyOffset(), (int)lfamlength);
        }
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), lfamlength, right.getFamilyArray(), right.getFamilyOffset(), rfamlength);
    }

    public static boolean matchingFamily(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getFamilyLength() == 0;
        }
        return PrivateCellUtil.matchingFamily(left, buf, 0, buf.length);
    }

    @Deprecated
    public static boolean matchingFamily(Cell left, byte[] buf, int offset, int length) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)left.getFamilyLength(), buf, offset, length);
        }
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), buf, offset, length);
    }

    public static boolean matchingQualifier(Cell left, Cell right) {
        int lqlength = left.getQualifierLength();
        int rqlength = right.getQualifierLength();
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), lqlength, ((ByteBufferCell)right).getQualifierByteBuffer(), ((ByteBufferCell)right).getQualifierPosition(), rqlength);
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), lqlength, right.getQualifierArray(), right.getQualifierOffset(), rqlength);
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)right).getQualifierByteBuffer(), ((ByteBufferCell)right).getQualifierPosition(), rqlength, left.getQualifierArray(), left.getQualifierOffset(), lqlength);
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), lqlength, right.getQualifierArray(), right.getQualifierOffset(), rqlength);
    }

    public static boolean matchingQualifier(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getQualifierLength() == 0;
        }
        return PrivateCellUtil.matchingQualifier(left, buf, 0, buf.length);
    }

    @Deprecated
    public static boolean matchingQualifier(Cell left, byte[] buf, int offset, int length) {
        if (buf == null) {
            return left.getQualifierLength() == 0;
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), left.getQualifierLength(), buf, offset, length);
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), buf, offset, length);
    }

    public static boolean matchingColumn(Cell left, byte[] fam, byte[] qual) {
        if (!CellUtil.matchingFamily(left, fam)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, qual);
    }

    @Deprecated
    public static boolean matchingColumn(Cell left, byte[] fam, int foffset, int flength, byte[] qual, int qoffset, int qlength) {
        if (!PrivateCellUtil.matchingFamily(left, fam, foffset, flength)) {
            return false;
        }
        return PrivateCellUtil.matchingQualifier(left, qual, qoffset, qlength);
    }

    public static boolean matchingColumn(Cell left, Cell right) {
        if (!CellUtil.matchingFamily(left, right)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, right);
    }

    public static boolean matchingValue(Cell left, Cell right) {
        return PrivateCellUtil.matchingValue(left, right, left.getValueLength(), right.getValueLength());
    }

    public static boolean matchingValue(Cell left, byte[] buf) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getValueByteBuffer(), ((ByteBufferCell)left).getValuePosition(), left.getValueLength(), buf, 0, buf.length) == 0;
        }
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), left.getValueLength(), buf, 0, buf.length);
    }

    public static boolean isDelete(Cell cell) {
        return PrivateCellUtil.isDelete(cell.getTypeByte());
    }

    @Deprecated
    public static boolean isDelete(byte type) {
        return KeyValue.Type.Delete.getCode() <= type && type <= KeyValue.Type.DeleteFamily.getCode();
    }

    @Deprecated
    public static boolean isDeleteType(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    @Deprecated
    public static boolean isDeleteFamily(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode();
    }

    @Deprecated
    public static boolean isDeleteFamilyVersion(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode();
    }

    @Deprecated
    public static boolean isDeleteColumns(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode();
    }

    @Deprecated
    public static boolean isDeleteColumnVersion(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    @Deprecated
    public static boolean isDeleteColumnOrFamily(Cell cell) {
        byte t = cell.getTypeByte();
        return t == KeyValue.Type.DeleteColumn.getCode() || t == KeyValue.Type.DeleteFamily.getCode();
    }

    @Deprecated
    public static int estimatedSerializedSizeOf(Cell cell) {
        if (cell instanceof ExtendedCell) {
            return ((ExtendedCell)cell).getSerializedSize(true) + 4;
        }
        return CellUtil.getSumOfCellElementLengths(cell) + 2 + 1 + 4;
    }

    private static int getSumOfCellElementLengths(Cell cell) {
        return CellUtil.getSumOfCellKeyElementLengths(cell) + cell.getValueLength() + cell.getTagsLength();
    }

    private static int getSumOfCellKeyElementLengths(Cell cell) {
        return cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + 9;
    }

    @Deprecated
    public static int estimatedSerializedSizeOfKey(Cell cell) {
        if (cell instanceof KeyValue) {
            return ((KeyValue)cell).getKeyLength();
        }
        return cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + 12;
    }

    @Deprecated
    public static long estimatedHeapSizeOf(Cell cell) {
        if (cell instanceof HeapSize) {
            return ((HeapSize)((Object)cell)).heapSize();
        }
        return CellUtil.estimatedSerializedSizeOf(cell);
    }

    @Deprecated
    public static Iterator<Tag> tagsIterator(final byte[] tags, final int offset, final int length) {
        return new Iterator<Tag>(){
            private int pos;
            private int endOffset;
            {
                this.pos = offset;
                this.endOffset = offset + length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.endOffset;
            }

            @Override
            public Tag next() {
                if (this.hasNext()) {
                    int curTagLen = Bytes.readAsInt(tags, this.pos, 2);
                    ArrayBackedTag tag = new ArrayBackedTag(tags, this.pos, curTagLen + 2);
                    this.pos += 2 + curTagLen;
                    return tag;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Deprecated
    public static List<Tag> getTags(Cell cell) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Iterator<Tag> tagsItr = PrivateCellUtil.tagsIterator(cell);
        while (tagsItr.hasNext()) {
            tags.add(tagsItr.next());
        }
        return tags;
    }

    @Deprecated
    public static Tag getTag(Cell cell, byte type) {
        int offset;
        int tagLen;
        boolean bufferBacked = cell instanceof ByteBufferCell;
        int length = cell.getTagsLength();
        for (int pos = offset = bufferBacked ? ((ByteBufferCell)cell).getTagsPosition() : cell.getTagsOffset(); pos < offset + length; pos += 2 + tagLen) {
            if (bufferBacked) {
                ByteBuffer tagsBuffer = ((ByteBufferCell)cell).getTagsByteBuffer();
                tagLen = ByteBufferUtils.readAsInt(tagsBuffer, pos, 2);
                if (ByteBufferUtils.toByte(tagsBuffer, pos + 2) != type) continue;
                return new ByteBufferTag(tagsBuffer, pos, tagLen + 2);
            }
            tagLen = Bytes.readAsInt(cell.getTagsArray(), pos, 2);
            if (cell.getTagsArray()[pos + 2] != type) continue;
            return new ArrayBackedTag(cell.getTagsArray(), pos, tagLen + 2);
        }
        return null;
    }

    @Deprecated
    public static boolean overlappingKeys(byte[] start1, byte[] end1, byte[] start2, byte[] end2) {
        return !(end2.length != 0 && start1.length != 0 && Bytes.compareTo(start1, end2) >= 0 || end1.length != 0 && start2.length != 0 && Bytes.compareTo(start2, end1) >= 0);
    }

    @Deprecated
    public static void setSequenceId(Cell cell, long seqId) throws IOException {
        if (!(cell instanceof SettableSequenceId)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableSequenceId.class.getName()));
        }
        ((SettableSequenceId)((Object)cell)).setSequenceId(seqId);
    }

    @Deprecated
    public static void setTimestamp(Cell cell, long ts) throws IOException {
        if (!(cell instanceof SettableTimestamp)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableTimestamp.class.getName()));
        }
        ((SettableTimestamp)((Object)cell)).setTimestamp(ts);
    }

    @Deprecated
    public static void setTimestamp(Cell cell, byte[] ts, int tsOffset) throws IOException {
        if (!(cell instanceof SettableTimestamp)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableTimestamp.class.getName()));
        }
        ((SettableTimestamp)((Object)cell)).setTimestamp(ts, tsOffset);
    }

    @Deprecated
    public static boolean updateLatestStamp(Cell cell, long ts) throws IOException {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            PrivateCellUtil.setTimestamp(cell, ts);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean updateLatestStamp(Cell cell, byte[] ts, int tsOffset) throws IOException {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            PrivateCellUtil.setTimestamp(cell, ts, tsOffset);
            return true;
        }
        return false;
    }

    @Deprecated
    public static void writeFlatKey(Cell cell, DataOutputStream out) throws IOException {
        short rowLen = cell.getRowLength();
        byte fLen = cell.getFamilyLength();
        int qLen = cell.getQualifierLength();
        if (cell instanceof ByteBufferCell) {
            out.writeShort(rowLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), (int)rowLen);
            out.writeByte(fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), (int)fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), qLen);
        } else {
            out.writeShort(rowLen);
            out.write(cell.getRowArray(), cell.getRowOffset(), rowLen);
            out.writeByte(fLen);
            out.write(cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
            out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qLen);
        }
        out.writeLong(cell.getTimestamp());
        out.writeByte(cell.getTypeByte());
    }

    @Deprecated
    public static void writeRowSkippingBytes(DataOutputStream out, Cell cell, short rlength, int commonPrefix) throws IOException {
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition() + commonPrefix, rlength - commonPrefix);
        } else {
            out.write(cell.getRowArray(), cell.getRowOffset() + commonPrefix, rlength - commonPrefix);
        }
    }

    public static String getCellKeyAsString(Cell cell) {
        StringBuilder sb = new StringBuilder(Bytes.toStringBinary(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
        sb.append('/');
        sb.append(cell.getFamilyLength() == 0 ? "" : Bytes.toStringBinary(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
        if (cell.getFamilyLength() > 0) {
            sb.append(':');
        }
        sb.append(cell.getQualifierLength() == 0 ? "" : Bytes.toStringBinary(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
        sb.append('/');
        sb.append(KeyValue.humanReadableTimestamp(cell.getTimestamp()));
        sb.append('/');
        sb.append((Object)KeyValue.Type.codeToType(cell.getTypeByte()));
        if (!(cell instanceof KeyValue.KeyOnlyKeyValue)) {
            sb.append("/vlen=");
            sb.append(cell.getValueLength());
        }
        sb.append("/seqid=");
        sb.append(cell.getSequenceId());
        return sb.toString();
    }

    @Deprecated
    public static byte[] getCellKeySerializedAsKeyValueKey(Cell cell) {
        if (cell == null) {
            return null;
        }
        byte[] b = new byte[KeyValueUtil.keyLength(cell)];
        KeyValueUtil.appendKeyTo(cell, b, 0);
        return b;
    }

    @Deprecated
    public static void writeRowKeyExcludingCommon(Cell cell, short rLen, int commonPrefix, DataOutputStream out) throws IOException {
        if (commonPrefix == 0) {
            out.writeShort(rLen);
        } else if (commonPrefix == 1) {
            out.writeByte((byte)rLen);
            --commonPrefix;
        } else {
            commonPrefix -= 2;
        }
        if (rLen > commonPrefix) {
            PrivateCellUtil.writeRowSkippingBytes(out, cell, rLen, commonPrefix);
        }
    }

    @Deprecated
    public static int findCommonPrefixInFlatKey(Cell c1, Cell c2, boolean bypassFamilyCheck, boolean withTsType) {
        short rLen1 = c1.getRowLength();
        short rLen2 = c2.getRowLength();
        int commonPrefix = 2;
        if (rLen1 != rLen2) {
            return ByteBufferUtils.findCommonPrefix(Bytes.toBytes(rLen1), 0, 2, Bytes.toBytes(rLen2), 0, 2);
        }
        int rkCommonPrefix = 0;
        rkCommonPrefix = c1 instanceof ByteBufferCell && c2 instanceof ByteBufferCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferCell)c1).getRowByteBuffer(), ((ByteBufferCell)c1).getRowPosition(), (int)rLen1, ((ByteBufferCell)c2).getRowByteBuffer(), ((ByteBufferCell)c2).getRowPosition(), (int)rLen2) : ByteBufferUtils.findCommonPrefix(c1.getRowArray(), c1.getRowOffset(), (int)rLen1, c2.getRowArray(), c2.getRowOffset(), (int)rLen2);
        commonPrefix += rkCommonPrefix;
        if (rkCommonPrefix != rLen1) {
            return commonPrefix;
        }
        byte fLen1 = c1.getFamilyLength();
        if (bypassFamilyCheck) {
            commonPrefix += 1 + fLen1;
        } else {
            byte fLen2 = c2.getFamilyLength();
            if (fLen1 != fLen2) {
                return commonPrefix;
            }
            ++commonPrefix;
            int fCommonPrefix = c1 instanceof ByteBufferCell && c2 instanceof ByteBufferCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferCell)c1).getFamilyByteBuffer(), ((ByteBufferCell)c1).getFamilyPosition(), (int)fLen1, ((ByteBufferCell)c2).getFamilyByteBuffer(), ((ByteBufferCell)c2).getFamilyPosition(), (int)fLen2) : ByteBufferUtils.findCommonPrefix(c1.getFamilyArray(), c1.getFamilyOffset(), (int)fLen1, c2.getFamilyArray(), c2.getFamilyOffset(), (int)fLen2);
            commonPrefix += fCommonPrefix;
            if (fCommonPrefix != fLen1) {
                return commonPrefix;
            }
        }
        int qLen1 = c1.getQualifierLength();
        int qLen2 = c2.getQualifierLength();
        int qCommon = c1 instanceof ByteBufferCell && c2 instanceof ByteBufferCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferCell)c1).getQualifierByteBuffer(), ((ByteBufferCell)c1).getQualifierPosition(), qLen1, ((ByteBufferCell)c2).getQualifierByteBuffer(), ((ByteBufferCell)c2).getQualifierPosition(), qLen2) : ByteBufferUtils.findCommonPrefix(c1.getQualifierArray(), c1.getQualifierOffset(), qLen1, c2.getQualifierArray(), c2.getQualifierOffset(), qLen2);
        commonPrefix += qCommon;
        if (!withTsType || Math.max(qLen1, qLen2) != qCommon) {
            return commonPrefix;
        }
        int tsCommonPrefix = ByteBufferUtils.findCommonPrefix(Bytes.toBytes(c1.getTimestamp()), 0, 8, Bytes.toBytes(c2.getTimestamp()), 0, 8);
        commonPrefix += tsCommonPrefix;
        if (tsCommonPrefix != 8) {
            return commonPrefix;
        }
        if (c1.getTypeByte() == c2.getTypeByte()) {
            ++commonPrefix;
        }
        return commonPrefix;
    }

    public static String toString(Cell cell, boolean verbose) {
        if (cell == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String keyStr = CellUtil.getCellKeyAsString(cell);
        String tag = null;
        String value = null;
        if (verbose) {
            if (cell.getTagsLength() > 0) {
                tag = Bytes.toStringBinary(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
            }
            if (!(cell instanceof KeyValue.KeyOnlyKeyValue)) {
                value = Bytes.toStringBinary(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            }
        }
        builder.append(keyStr);
        if (tag != null && !tag.isEmpty()) {
            builder.append("/").append(tag);
        }
        if (value != null) {
            builder.append("/").append(value);
        }
        return builder.toString();
    }

    @Deprecated
    public static boolean equalsIgnoreMvccVersion(Cell a, Cell b) {
        boolean res = CellUtil.matchingRows(a, b);
        if (!res) {
            return res;
        }
        res = CellUtil.matchingColumn(a, b);
        if (!res) {
            return res;
        }
        if (!CellUtil.matchingTimestamp(a, b)) {
            return false;
        }
        int c = (0xFF & b.getTypeByte()) - (0xFF & a.getTypeByte());
        return c == 0;
    }

    public static boolean equals(Cell a, Cell b) {
        return CellUtil.matchingRows(a, b) && CellUtil.matchingFamily(a, b) && CellUtil.matchingQualifier(a, b) && CellUtil.matchingTimestamp(a, b) && PrivateCellUtil.matchingType(a, b);
    }

    public static boolean matchingTimestamp(Cell a, Cell b) {
        return CellComparatorImpl.COMPARATOR.compareTimestamps(a.getTimestamp(), b.getTimestamp()) == 0;
    }

    @Deprecated
    public static boolean matchingType(Cell a, Cell b) {
        return a.getTypeByte() == b.getTypeByte();
    }

    public static boolean matchingRows(Cell left, Cell right) {
        short rrowlength;
        short lrowlength = left.getRowLength();
        if (lrowlength != (rrowlength = right.getRowLength())) {
            return false;
        }
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)lrowlength, ((ByteBufferCell)right).getRowByteBuffer(), ((ByteBufferCell)right).getRowPosition(), (int)rrowlength);
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)lrowlength, right.getRowArray(), right.getRowOffset(), (int)rrowlength);
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)right).getRowByteBuffer(), ((ByteBufferCell)right).getRowPosition(), (int)rrowlength, left.getRowArray(), left.getRowOffset(), (int)lrowlength);
        }
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), lrowlength, right.getRowArray(), right.getRowOffset(), rrowlength);
    }

    public static boolean matchingRowColumn(Cell left, Cell right) {
        if (left.getRowLength() + left.getFamilyLength() + left.getQualifierLength() != right.getRowLength() + right.getFamilyLength() + right.getQualifierLength()) {
            return false;
        }
        if (!CellUtil.matchingRows(left, right)) {
            return false;
        }
        return CellUtil.matchingColumn(left, right);
    }

    public static final int compareQualifiers(Cell left, byte[] right, int rOffset, int rLength) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), left.getQualifierLength(), right, rOffset, rLength);
        }
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right, rOffset, rLength);
    }

    @Deprecated
    @VisibleForTesting
    public static final int compare(CellComparator comparator, Cell left, byte[] key, int offset, int length) {
        short rrowlength = Bytes.toShort(key, offset);
        int c = comparator.compareRows(left, key, offset + 2, rrowlength);
        if (c != 0) {
            return c;
        }
        return PrivateCellUtil.compareWithoutRow(comparator, left, key, offset, length, rrowlength);
    }

    public static final int compareFamilies(Cell left, byte[] right, int roffset, int rlength) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)left.getFamilyLength(), right, roffset, rlength);
        }
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right, roffset, rlength);
    }

    public static final int compareColumns(Cell left, byte[] right, int rfoffset, int rflength, int rqoffset, int rqlength) {
        int diff = CellUtil.compareFamilies(left, right, rfoffset, rflength);
        if (diff != 0) {
            return diff;
        }
        return CellUtil.compareQualifiers(left, right, rqoffset, rqlength);
    }
}

