/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenameMetalakeRequest.class, name="rename"), @JsonSubTypes.Type(value=UpdateMetalakeCommentRequest.class, name="updateComment"), @JsonSubTypes.Type(value=SetMetalakePropertyRequest.class, name="setProperty"), @JsonSubTypes.Type(value=RemoveMetalakePropertyRequest.class, name="removeProperty")})
public interface MetalakeUpdateRequest
extends RESTRequest {
    public MetalakeChange metalakeChange();

    public static class RemoveMetalakePropertyRequest
    implements MetalakeUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        public RemoveMetalakePropertyRequest(String property) {
            this.property = property;
        }

        public RemoveMetalakePropertyRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.property), "\"property\" field is required and cannot be empty");
        }

        @Override
        public MetalakeChange metalakeChange() {
            return MetalakeChange.removeProperty(this.property);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveMetalakePropertyRequest)) {
                return false;
            }
            RemoveMetalakePropertyRequest other = (RemoveMetalakePropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveMetalakePropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public String toString() {
            return "MetalakeUpdateRequest.RemoveMetalakePropertyRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetMetalakePropertyRequest
    implements MetalakeUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        public SetMetalakePropertyRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public SetMetalakePropertyRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.property), "\"property\" field is required and cannot be empty");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.value), "\"value\" field is required and cannot be empty");
        }

        @Override
        public MetalakeChange metalakeChange() {
            return MetalakeChange.setProperty(this.property, this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetMetalakePropertyRequest)) {
                return false;
            }
            SetMetalakePropertyRequest other = (SetMetalakePropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.value;
            String other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetMetalakePropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "MetalakeUpdateRequest.SetMetalakePropertyRequest(property=" + this.getProperty() + ", value=" + this.value + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class UpdateMetalakeCommentRequest
    implements MetalakeUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        public UpdateMetalakeCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        public UpdateMetalakeCommentRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
        }

        @Override
        public MetalakeChange metalakeChange() {
            return MetalakeChange.updateComment(this.newComment);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateMetalakeCommentRequest)) {
                return false;
            }
            UpdateMetalakeCommentRequest other = (UpdateMetalakeCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateMetalakeCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public String toString() {
            return "MetalakeUpdateRequest.UpdateMetalakeCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class RenameMetalakeRequest
    implements MetalakeUpdateRequest {
        @JsonProperty(value="newName")
        private final String newName;

        public RenameMetalakeRequest(String newName) {
            this.newName = newName;
        }

        public RenameMetalakeRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.newName), "\"newName\" field is required and cannot be empty");
        }

        @Override
        public MetalakeChange metalakeChange() {
            return MetalakeChange.rename(this.newName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameMetalakeRequest)) {
                return false;
            }
            RenameMetalakeRequest other = (RenameMetalakeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameMetalakeRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public String toString() {
            return "MetalakeUpdateRequest.RenameMetalakeRequest(newName=" + this.getNewName() + ")";
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

