/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Arrays;
import java.util.List;
import org.apache.gravitino.Audit;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ListGroups
extends Command {
    protected final String metalake;

    public ListGroups(CommandContext context, String metalake) {
        super(context);
        this.metalake = metalake;
    }

    @Override
    public void handle() {
        String[] groups = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            groups = client.listGroupNames();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (groups.length == 0) {
            this.printInformation("No groups found in metalake " + this.metalake);
        } else {
            Group[] groupObjects = (Group[])Arrays.stream(groups).map(this::getGroup).toArray(Group[]::new);
            this.printResults(groupObjects);
        }
    }

    private Group getGroup(final String name) {
        return new Group(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public List<String> roles() {
                return null;
            }

            @Override
            public Audit auditInfo() {
                return null;
            }
        };
    }
}

