/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class MetalakeCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final CommandContext context;
    private final String command;
    private String metalake;

    public MetalakeCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
    }

    @Override
    public void handle() {
        String userName = this.line.getOptionValue("login");
        FullName name = new FullName(this.line);
        Command.setAuthenticationMode(this.context.auth(), userName);
        if ("list".equals(this.command)) {
            this.handleListCommand();
            return;
        }
        this.metalake = name.getMetalakeName();
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
            case "remove": {
                this.handleRemoveCommand();
                return true;
            }
            case "properties": {
                this.handlePropertiesCommand();
                return true;
            }
            case "update": {
                this.handleUpdateCommand();
                return true;
            }
        }
        return false;
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListMetalakes(this.context).validate().handle();
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newMetalakeAudit(this.context, this.metalake).validate().handle();
        } else {
            this.gravitinoCommandLine.newMetalakeDetails(this.context, this.metalake).validate().handle();
        }
    }

    private void handleCreateCommand() {
        String comment = this.line.getOptionValue("comment");
        this.gravitinoCommandLine.newCreateMetalake(this.context, this.metalake, comment).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteMetalake(this.context, this.metalake).validate().handle();
    }

    private void handleSetCommand() {
        String property = this.line.getOptionValue("property");
        String value = this.line.getOptionValue("value");
        this.gravitinoCommandLine.newSetMetalakeProperty(this.context, this.metalake, property, value).validate().handle();
    }

    private void handleRemoveCommand() {
        String property = this.line.getOptionValue("property");
        this.gravitinoCommandLine.newRemoveMetalakeProperty(this.context, this.metalake, property).validate().handle();
    }

    private void handlePropertiesCommand() {
        this.gravitinoCommandLine.newListMetalakeProperties(this.context, this.metalake).validate().handle();
    }

    private void handleUpdateCommand() {
        if (this.line.hasOption("enable") || this.line.hasOption("disable")) {
            this.gravitinoCommandLine.newManageMetalake(this.context, this.metalake).validate().handle();
        }
        if (this.line.hasOption("comment")) {
            String comment = this.line.getOptionValue("comment");
            this.gravitinoCommandLine.newUpdateMetalakeComment(this.context, this.metalake, comment).validate().handle();
        }
        if (this.line.hasOption("rename")) {
            String newName = this.line.getOptionValue("rename");
            this.gravitinoCommandLine.newUpdateMetalakeName(this.context, this.metalake, newName).validate().handle();
        }
    }
}

