/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class CatalogListResponse
extends BaseResponse {
    @JsonProperty(value="catalogs")
    private final CatalogDTO[] catalogs;

    public CatalogListResponse(CatalogDTO[] catalogs) {
        super(0);
        this.catalogs = catalogs;
    }

    public CatalogListResponse() {
        this.catalogs = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.catalogs != null ? 1 : 0) != 0, (Object)"catalogs must be non-null");
        Arrays.stream(this.catalogs).forEach(catalog -> {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)catalog.name()), (Object)"catalog 'name' must not be null and empty");
            Preconditions.checkArgument((catalog.type() != null ? 1 : 0) != 0, (Object)"catalog 'type' must not be null");
            Preconditions.checkArgument((catalog.auditInfo() != null ? 1 : 0) != 0, (Object)"catalog 'audit' must not be null");
        });
    }

    public CatalogDTO[] getCatalogs() {
        return this.catalogs;
    }

    @Override
    public String toString() {
        return "CatalogListResponse(catalogs=" + Arrays.deepToString(this.getCatalogs()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogListResponse)) {
            return false;
        }
        CatalogListResponse other = (CatalogListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getCatalogs(), other.getCatalogs());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CatalogListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getCatalogs());
        return result;
    }
}

