/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import org.apache.zookeeper.server.quorum.LocalPeerMXBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.ServerBean;

public class LocalPeerBean
extends ServerBean
implements LocalPeerMXBean {
    private final QuorumPeer peer;

    public LocalPeerBean(QuorumPeer peer) {
        this.peer = peer;
    }

    @Override
    public String getName() {
        return "replica." + this.peer.getId();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public int getTickTime() {
        return this.peer.getTickTime();
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.peer.getMaxClientCnxnsPerHost();
    }

    @Override
    public int getMinSessionTimeout() {
        return this.peer.getMinSessionTimeout();
    }

    @Override
    public int getMaxSessionTimeout() {
        return this.peer.getMaxSessionTimeout();
    }

    @Override
    public int getInitLimit() {
        return this.peer.getInitLimit();
    }

    @Override
    public int getSyncLimit() {
        return this.peer.getSyncLimit();
    }

    @Override
    public int getTick() {
        return this.peer.getTick();
    }

    @Override
    public String getState() {
        return this.peer.getServerState();
    }

    @Override
    public String getQuorumAddress() {
        return this.peer.getQuorumAddress().toString();
    }

    @Override
    public int getElectionType() {
        return this.peer.getElectionType();
    }

    @Override
    public String getElectionAddress() {
        return this.peer.getElectionAddress().getHostString() + ":" + this.peer.getElectionAddress().getPort();
    }

    @Override
    public String getClientAddress() {
        if (null != this.peer.cnxnFactory) {
            return String.format("%s:%d", this.peer.cnxnFactory.getLocalAddress().getHostString(), this.peer.getClientPort());
        }
        return "";
    }

    @Override
    public String getLearnerType() {
        return this.peer.getLearnerType().toString();
    }

    @Override
    public long getConfigVersion() {
        return this.peer.getQuorumVerifier().getVersion();
    }

    @Override
    public String getQuorumSystemInfo() {
        return this.peer.getQuorumVerifier().toString();
    }

    @Override
    public boolean isPartOfEnsemble() {
        return this.peer.getView().containsKey(this.peer.getId());
    }
}

