/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;

public class FifoAppAttempt
extends FiCaSchedulerApp {
    private static final Log LOG = LogFactory.getLog(FifoAppAttempt.class);

    FifoAppAttempt(ApplicationAttemptId appAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        super(appAttemptId, user, queue, activeUsersManager, rmContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMContainer allocate(NodeType type, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, Container container) {
        try {
            this.writeLock.lock();
            if (this.isStopped) {
                RMContainer rMContainer = null;
                return rMContainer;
            }
            if (this.getOutstandingAsksCount(schedulerKey) <= 0) {
                RMContainer rMContainer = null;
                return rMContainer;
            }
            RMContainerImpl rmContainer = new RMContainerImpl(container, schedulerKey, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext, node.getPartition());
            rmContainer.setQueueName(this.getQueueName());
            this.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ASSIGNED, null);
            this.addToNewlyAllocatedContainers(node, rmContainer);
            ContainerId containerId = container.getId();
            this.liveContainers.put(containerId, rmContainer);
            ContainerRequest containerRequest = this.appSchedulingInfo.allocate(type, node, schedulerKey, container);
            this.attemptResourceUsage.incUsed(node.getPartition(), container.getResource());
            rmContainer.setContainerRequest(containerRequest);
            rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.START));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: applicationAttemptId=" + containerId.getApplicationAttemptId() + " container=" + containerId + " host=" + container.getNodeId().getHost() + " type=" + (Object)((Object)type)));
            }
            RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), containerId, container.getResource());
            RMContainerImpl rMContainerImpl = rmContainer;
            return rMContainerImpl;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

