/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.hive.HiveTableHandle;
import org.apache.gravitino.catalog.hive.TableType;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.hive.CachedClientPool;
import org.apache.gravitino.hive.HiveSchema;
import org.apache.gravitino.hive.HiveTable;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalogOperations
implements CatalogOperations,
SupportsSchemas,
TableCatalog {
    public static final Logger LOG = LoggerFactory.getLogger(HiveCatalogOperations.class);
    @VisibleForTesting
    CachedClientPool clientPool;
    private CatalogInfo info;
    private HasPropertyMetadata propertiesMetadata;
    private String catalogName;
    private boolean listAllTables = true;
    private static final short MAX_TABLES = -1;
    public static final Map<String, String> GRAVITINO_CONFIG_TO_HIVE = ImmutableMap.of((Object)"metastore.uris", (Object)"hive.metastore.uris", (Object)"impersonation-enable", (Object)"authentication.impersonation-enable", (Object)"kerberos.keytab-uri", (Object)"authentication.kerberos.keytab-uri", (Object)"kerberos.principal", (Object)"authentication.kerberos.principal");

    public void initialize(Map<String, String> conf, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        String defaultCatalog;
        this.info = info;
        this.propertiesMetadata = propertiesMetadata;
        Properties prop = this.mergeProperties(conf);
        String catalogKey = String.format("hive-%s", info == null || info.id() == null ? "0" : info.id());
        this.clientPool = new CachedClientPool(catalogKey, prop, conf);
        this.listAllTables = this.enableListAllTables(conf);
        this.catalogName = defaultCatalog = (String)propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "default.catalog");
    }

    @VisibleForTesting
    protected Properties mergeProperties(Map<String, String> conf) {
        HashMap byPassConfig = Maps.newHashMap();
        HashMap gravitinoConfig = Maps.newHashMap();
        conf.forEach((key, value) -> {
            if (key.startsWith("gravitino.bypass.")) {
                String hiveKey = key.substring("gravitino.bypass.".length());
                if (!hiveKey.isEmpty()) {
                    byPassConfig.put(hiveKey, value);
                } else {
                    LOG.warn("Ignoring invalid configuration key: {}", key);
                }
            } else if (GRAVITINO_CONFIG_TO_HIVE.containsKey(key)) {
                gravitinoConfig.put(GRAVITINO_CONFIG_TO_HIVE.get(key), value);
            }
        });
        Properties prop = new Properties();
        byPassConfig.forEach(prop::setProperty);
        gravitinoConfig.forEach(prop::setProperty);
        return prop;
    }

    boolean enableListAllTables(Map<String, String> conf) {
        return (Boolean)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "list-all-tables");
    }

    public void close() {
        if (this.clientPool != null) {
            this.clientPool.close();
            this.clientPool = null;
        }
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        try {
            NameIdentifier[] schemas = (NameIdentifier[])this.clientPool.run(c -> (NameIdentifier[])c.getAllDatabases(this.catalogName).stream().map(db -> NameIdentifier.of((Namespace)namespace, (String)db)).toArray(NameIdentifier[]::new));
            return schemas;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public HiveSchema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        try {
            HiveSchema hiveSchema = (HiveSchema)((HiveSchema.Builder)((HiveSchema.Builder)((HiveSchema.Builder)((HiveSchema.Builder)HiveSchema.builder().withName(ident.name())).withComment(comment)).withCatalogName(this.catalogName).withProperties(properties)).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentUserName()).withCreateTime(Instant.now()).build())).build();
            this.clientPool.run(client -> {
                client.createDatabase(hiveSchema);
                return null;
            });
            LOG.info("Created Hive schema (database) {} in Hive Metastore", (Object)ident.name());
            return hiveSchema;
        }
        catch (NoSuchCatalogException | SchemaAlreadyExistsException ne) {
            throw ne;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HiveSchema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        try {
            HiveSchema database = (HiveSchema)this.clientPool.run(client -> client.getDatabase(this.catalogName, ident.name()));
            LOG.info("Loaded Hive schema (database) {} from Hive Metastore ", (Object)ident.name());
            return database;
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchSchemaException("Schema %s does not exist", new Object[]{ident.name()});
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public HiveSchema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        try {
            HiveSchema database = (HiveSchema)this.clientPool.run(client -> client.getDatabase(this.catalogName, ident.name()));
            Map properties = database.properties();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded properties for Hive schema (database) {} found {}", (Object)ident.name(), properties.keySet());
            }
            for (SchemaChange change : changes) {
                if (change instanceof SchemaChange.SetProperty) {
                    properties.put(((SchemaChange.SetProperty)change).getProperty(), ((SchemaChange.SetProperty)change).getValue());
                    continue;
                }
                if (change instanceof SchemaChange.RemoveProperty) {
                    properties.remove(((SchemaChange.RemoveProperty)change).getProperty());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported schema change type: " + change.getClass().getSimpleName());
            }
            this.clientPool.run(client -> {
                client.alterDatabase(this.catalogName, ident.name(), database);
                return null;
            });
            LOG.info("Altered Hive schema (database) {} in Hive Metastore", (Object)ident.name());
            return database;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        try {
            this.clientPool.run(client -> {
                client.dropDatabase(this.catalogName, ident.name(), cascade);
                return null;
            });
            LOG.info("Dropped Hive schema (database) {}", (Object)ident.name());
            return true;
        }
        catch (NoSuchSchemaException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])namespace.levels());
        if (!this.schemaExists(schemaIdent)) {
            throw new NoSuchSchemaException("Schema (database) does not exist %s", new Object[]{namespace});
        }
        try {
            List allTables = (List)this.clientPool.run(c -> c.getAllTables(this.catalogName, schemaIdent.name()));
            if (!this.listAllTables) {
                String icebergAndPaimonFilter = HiveCatalogOperations.getIcebergAndPaimonFilter();
                List icebergAndPaimonTables = (List)this.clientPool.run(c -> c.listTableNamesByFilter(this.catalogName, schemaIdent.name(), icebergAndPaimonFilter, (short)-1));
                allTables.removeAll(icebergAndPaimonTables);
                String hudiFilter = String.format("%sprovider like \"hudi\"", "hive_filter_field_params__");
                List hudiTables = (List)this.clientPool.run(c -> c.listTableNamesByFilter(this.catalogName, schemaIdent.name(), hudiFilter, (short)-1));
                this.removeHudiTables(allTables, hudiTables);
            }
            return (NameIdentifier[])allTables.stream().map(tbName -> NameIdentifier.of((Namespace)namespace, (String)tbName)).toArray(NameIdentifier[]::new);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getIcebergAndPaimonFilter() {
        String icebergFilter = String.format("%stable_type like \"ICEBERG\"", "hive_filter_field_params__");
        String paimonFilter = String.format("%stable_type like \"PAIMON\"", "hive_filter_field_params__");
        return String.format("%s or %s", icebergFilter, paimonFilter);
    }

    private void removeHudiTables(List<String> allTables, List<String> hudiTables) {
        for (String hudiTable : hudiTables) {
            allTables.removeIf(t -> t.equals(hudiTable) || t.startsWith(hudiTable + "_ro") || t.startsWith(hudiTable + "_rt"));
        }
    }

    public Table loadTable(NameIdentifier tableIdent) throws NoSuchTableException {
        HiveTableHandle hiveTable = this.loadHiveTable(tableIdent);
        LOG.info("Loaded Hive table {} from Hive Metastore ", (Object)tableIdent.name());
        return hiveTable;
    }

    private HiveTableHandle loadHiveTable(NameIdentifier tableIdent) {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        try {
            HiveTable table = (HiveTable)this.clientPool.run(c -> c.getTable(this.catalogName, schemaIdent.name(), tableIdent.name()));
            return new HiveTableHandle(table, this.clientPool);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to load Hive table " + tableIdent.name() + " from Hive metastore", e);
        }
    }

    private void validatePartitionForCreate(Column[] columns, Transform[] partitioning) {
        int partitionStartIndex = columns.length - partitioning.length;
        for (int i = 0; i < partitioning.length; ++i) {
            Preconditions.checkArgument((boolean)(partitioning[i] instanceof Transforms.IdentityTransform), (Object)"Hive partition only supports identity transform");
            Transforms.IdentityTransform identity = (Transforms.IdentityTransform)partitioning[i];
            Preconditions.checkArgument((identity.fieldName().length == 1 ? 1 : 0) != 0, (Object)"Hive partition does not support nested field");
            Preconditions.checkArgument((boolean)columns[partitionStartIndex + i].name().equals(identity.fieldName()[0]), (Object)"The partition field must be placed at the end of the columns in order");
        }
    }

    private void validateColumnChangeForAlter(TableChange[] changes, HiveTable hiveTable) {
        HashSet partitionFields = new HashSet(hiveTable.partitionFieldNames());
        Set existingFields = Arrays.stream(hiveTable.columns()).map(Column::name).collect(Collectors.toSet());
        existingFields.addAll(partitionFields);
        Arrays.stream(changes).filter(c -> c instanceof TableChange.ColumnChange).forEach(c -> {
            String fieldName = String.join((CharSequence)".", ((TableChange.ColumnChange)c).fieldName());
            Preconditions.checkArgument((c instanceof TableChange.UpdateColumnComment || !partitionFields.contains(fieldName) ? 1 : 0) != 0, (Object)("Cannot alter partition column: " + fieldName));
            if (c instanceof TableChange.UpdateColumnPosition && this.afterPartitionColumn(partitionFields, ((TableChange.UpdateColumnPosition)c).getPosition())) {
                throw new IllegalArgumentException("Cannot alter column position to after partition column");
            }
            if (c instanceof TableChange.DeleteColumn) {
                existingFields.remove(fieldName);
            }
            if (c instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)c;
                if (existingFields.contains(fieldName)) {
                    throw new IllegalArgumentException("Cannot add column with duplicate name: " + fieldName);
                }
                if (addColumn.getPosition() == null) {
                    return;
                }
                if (this.afterPartitionColumn(partitionFields, addColumn.getPosition())) {
                    throw new IllegalArgumentException("Cannot add column after partition column");
                }
            }
        });
    }

    private boolean afterPartitionColumn(Set<String> partitionFields, TableChange.ColumnPosition columnPosition) {
        Preconditions.checkArgument((columnPosition != null ? 1 : 0) != 0, (Object)"Column position cannot be null");
        if (columnPosition instanceof TableChange.After) {
            return partitionFields.contains(((TableChange.After)columnPosition).getColumn());
        }
        return false;
    }

    private void validateDistributionAndSort(Distribution distribution, SortOrder[] sortOrder) {
        boolean allNameReference;
        if (distribution != Distributions.NONE) {
            allNameReference = Arrays.stream(distribution.expressions()).allMatch(t -> t instanceof NamedReference.FieldReference);
            Preconditions.checkArgument((boolean)allNameReference, (Object)"Hive distribution only supports field reference");
        }
        if (ArrayUtils.isNotEmpty((Object[])sortOrder)) {
            allNameReference = Arrays.stream(sortOrder).allMatch(t -> t.expression() instanceof NamedReference.FieldReference);
            Preconditions.checkArgument((boolean)allNameReference, (Object)"Hive sort order only supports name reference");
        }
    }

    public Table createTable(NameIdentifier tableIdent, Column[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        Preconditions.checkArgument((indexes.length == 0 ? 1 : 0) != 0, (Object)"Hive-catalog does not support indexes, since indexing was removed since 3.0");
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        this.validatePartitionForCreate(columns, partitioning);
        this.validateDistributionAndSort(distribution, sortOrders);
        TableType tableType = (TableType)this.propertiesMetadata.tablePropertiesMetadata().getOrDefault(properties, "table-type");
        Preconditions.checkArgument((boolean)HiveTable.SUPPORT_TABLE_TYPES.contains(tableType.name()), (Object)("Unsupported table type: " + tableType.name()));
        try {
            if (!this.schemaExists(schemaIdent)) {
                LOG.warn("Hive schema (database) does not exist: {}", (Object)schemaIdent);
                throw new NoSuchSchemaException("Hive Schema (database) does not exist: %s ", new Object[]{schemaIdent});
            }
            HiveTable hiveTable = (HiveTable)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)HiveTable.builder().withName(tableIdent.name())).withCatalogName(this.catalogName).withDatabaseName(schemaIdent.name()).withComment(comment)).withColumns(columns)).withProperties(properties)).withDistribution(distribution)).withSortOrders(sortOrders)).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentUserName()).withCreateTime(Instant.now()).build())).withPartitioning(partitioning)).build();
            this.clientPool.run(c -> {
                c.createTable(hiveTable);
                return null;
            });
            LOG.info("Created Hive table {} in Hive Metastore", (Object)tableIdent.name());
            return new HiveTableHandle(hiveTable, this.clientPool);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Table alterTable(NameIdentifier tableIdent, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        try {
            HiveTable updatedTable;
            HiveTableHandle tableHandle = (HiveTableHandle)this.loadTable(tableIdent);
            HiveTable currentTable = tableHandle.table();
            this.validateColumnChangeForAlter(changes, currentTable);
            String newTableName = currentTable.name();
            String newComment = currentTable.comment();
            HashMap<String, String> updatedProperties = new HashMap<String, String>(currentTable.properties());
            ArrayList<Column> updatedColumns = new ArrayList<Column>(Arrays.asList(currentTable.columns()));
            for (TableChange change : changes) {
                if (change instanceof TableChange.RenameTable) {
                    TableChange.RenameTable rename = (TableChange.RenameTable)change;
                    Preconditions.checkArgument((boolean)rename.getNewSchemaName().isEmpty(), (Object)"Does not support rename schema yet");
                    newTableName = rename.getNewName();
                    continue;
                }
                if (change instanceof TableChange.UpdateComment) {
                    newComment = ((TableChange.UpdateComment)change).getNewComment();
                    continue;
                }
                if (change instanceof TableChange.SetProperty) {
                    TableChange.SetProperty setProperty = (TableChange.SetProperty)change;
                    updatedProperties.put(setProperty.getProperty(), setProperty.getValue());
                    continue;
                }
                if (change instanceof TableChange.RemoveProperty) {
                    TableChange.RemoveProperty removeProperty = (TableChange.RemoveProperty)change;
                    updatedProperties.remove(removeProperty.getProperty());
                    continue;
                }
                if (change instanceof TableChange.ColumnChange) {
                    this.applyColumnChange(updatedColumns, (TableChange.ColumnChange)change);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported table change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
            }
            HiveTable finalUpdatedTable = updatedTable = this.buildAlteredHiveTable(currentTable, newTableName, newComment, updatedProperties, updatedColumns);
            this.clientPool.run(c -> {
                c.alterTable(this.catalogName, schemaIdent.name(), tableIdent.name(), finalUpdatedTable);
                return null;
            });
            LOG.info("Altered Hive table {} in Hive Metastore", (Object)tableIdent.name());
            return new HiveTableHandle(updatedTable, this.clientPool);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("types incompatible with the existing columns")) {
                throw new IllegalArgumentException("Failed to alter Hive table [" + tableIdent.name() + "] in Hive metastore, since Hive metastore will check the compatibility of column type between the old and new column positions, please ensure that the type of the new column position is compatible with the old one, otherwise the alter operation will fail in Hive metastore.", e);
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private HiveTable buildAlteredHiveTable(HiveTable original, String tableName, String comment, Map<String, String> properties, List<Column> columns) {
        HiveTable.Builder builder = ((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)HiveTable.builder().withName(tableName)).withColumns(columns.toArray(new Column[0]))).withProperties(properties)).withAuditInfo(original.auditInfo())).withDistribution(original.distribution())).withSortOrders(original.sortOrder())).withPartitioning(original.partitioning())).withCatalogName(original.catalogName()).withDatabaseName(original.databaseName());
        if (comment != null) {
            builder.withComment(comment);
        }
        return (HiveTable)builder.build();
    }

    private void applyColumnChange(List<Column> columns, TableChange.ColumnChange change) {
        if (change instanceof TableChange.AddColumn) {
            this.doAddColumn(columns, (TableChange.AddColumn)change);
        } else if (change instanceof TableChange.DeleteColumn) {
            this.doDeleteColumn(columns, (TableChange.DeleteColumn)change);
        } else if (change instanceof TableChange.RenameColumn) {
            this.doRenameColumn(columns, (TableChange.RenameColumn)change);
        } else if (change instanceof TableChange.UpdateColumnComment) {
            this.doUpdateColumnComment(columns, (TableChange.UpdateColumnComment)change);
        } else if (change instanceof TableChange.UpdateColumnPosition) {
            this.doUpdateColumnPosition(columns, (TableChange.UpdateColumnPosition)change);
        } else if (change instanceof TableChange.UpdateColumnType) {
            this.doUpdateColumnType(columns, (TableChange.UpdateColumnType)change);
        } else if (change instanceof TableChange.UpdateColumnDefaultValue) {
            this.doUpdateColumnDefaultValue(columns, (TableChange.UpdateColumnDefaultValue)change);
        } else if (change instanceof TableChange.UpdateColumnNullability) {
            this.doUpdateColumnNullability(columns, (TableChange.UpdateColumnNullability)change);
        } else {
            if (change instanceof TableChange.UpdateColumnAutoIncrement) {
                throw new IllegalArgumentException("Hive does not support altering column auto increment");
            }
            throw new IllegalArgumentException("Unsupported column change type: " + change.getClass().getSimpleName());
        }
    }

    private int columnPosition(List<Column> columns, TableChange.ColumnPosition position) {
        if (position == null || position instanceof TableChange.Default) {
            return columns.size();
        }
        if (position instanceof TableChange.After) {
            String afterColumn = ((TableChange.After)position).getColumn();
            int indexOfColumn = this.indexOfColumn(columns, afterColumn);
            Preconditions.checkArgument((indexOfColumn != -1 ? 1 : 0) != 0, (Object)("Column does not exist: " + afterColumn));
            return indexOfColumn + 1;
        }
        if (position instanceof TableChange.First) {
            return 0;
        }
        throw new UnsupportedOperationException("Unsupported column position type: " + position.getClass().getSimpleName());
    }

    private int indexOfColumn(List<Column> columns, String fieldName) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).name().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    private void doAddColumn(List<Column> columns, TableChange.AddColumn change) {
        String columnName = this.topLevelFieldName(change.getFieldName());
        if (change.isAutoIncrement()) {
            throw new IllegalArgumentException("Hive catalog does not support auto-increment column");
        }
        Preconditions.checkArgument((this.indexOfColumn(columns, columnName) == -1 ? 1 : 0) != 0, (Object)("Column already exists: " + columnName));
        int targetPosition = this.columnPosition(columns, change.getPosition());
        columns.add(targetPosition, (Column)Column.of((String)columnName, (Type)change.getDataType(), (String)change.getComment(), (boolean)change.isNullable(), (boolean)change.isAutoIncrement(), (Expression)this.defaultValueOrUnset(change.getDefaultValue())));
    }

    private void doDeleteColumn(List<Column> columns, TableChange.DeleteColumn change) {
        String columnName = this.topLevelFieldName(change.fieldName());
        int index = this.indexOfColumn(columns, columnName);
        if (index == -1) {
            if (!change.getIfExists().booleanValue()) {
                throw new IllegalArgumentException("DeleteColumn does not exist: " + columnName);
            }
            return;
        }
        columns.remove(index);
    }

    private void doRenameColumn(List<Column> columns, TableChange.RenameColumn change) {
        String columnName = this.topLevelFieldName(change.fieldName());
        int index = this.indexOfColumn(columns, columnName);
        if (index == -1) {
            throw new IllegalArgumentException("RenameColumn does not exist: " + columnName);
        }
        String newName = change.getNewName();
        Preconditions.checkArgument((this.indexOfColumn(columns, newName) == -1 ? 1 : 0) != 0, (Object)("Column already exists: " + newName));
        Column existing = columns.get(index);
        columns.set(index, this.rebuildColumn(existing, newName, null, null, null, null, null));
    }

    private void doUpdateColumnComment(List<Column> columns, TableChange.UpdateColumnComment change) {
        int index = this.indexOfColumn(columns, this.topLevelFieldName(change.fieldName()));
        if (index == -1) {
            throw new IllegalArgumentException("UpdateColumnComment does not exist: " + change.fieldName()[0]);
        }
        Column existing = columns.get(index);
        columns.set(index, this.rebuildColumn(existing, null, null, change.getNewComment(), null, null, null));
    }

    private void doUpdateColumnPosition(List<Column> columns, TableChange.UpdateColumnPosition change) {
        String columnName = this.topLevelFieldName(change.fieldName());
        int sourceIndex = this.indexOfColumn(columns, columnName);
        if (sourceIndex == -1) {
            throw new IllegalArgumentException("UpdateColumnPosition does not exist: " + columnName);
        }
        Column column = columns.remove(sourceIndex);
        int targetIndex = this.columnPosition(columns, change.getPosition());
        columns.add(targetIndex, column);
    }

    private void doUpdateColumnType(List<Column> columns, TableChange.UpdateColumnType change) {
        String columnName = this.topLevelFieldName(change.getFieldName());
        int index = this.indexOfColumn(columns, columnName);
        if (index == -1) {
            throw new IllegalArgumentException("UpdateColumnType does not exist: " + columnName);
        }
        Column existing = columns.get(index);
        columns.set(index, this.rebuildColumn(existing, null, change.getNewDataType(), null, null, null, null));
    }

    private void doUpdateColumnDefaultValue(List<Column> columns, TableChange.UpdateColumnDefaultValue change) {
        String columnName = this.topLevelFieldName(change.fieldName());
        int index = this.indexOfColumn(columns, columnName);
        if (index == -1) {
            throw new IllegalArgumentException("UpdateColumnDefaultValue does not exist: " + columnName);
        }
        Column existing = columns.get(index);
        columns.set(index, this.rebuildColumn(existing, null, null, null, null, null, change.getNewDefaultValue()));
    }

    private void doUpdateColumnNullability(List<Column> columns, TableChange.UpdateColumnNullability change) {
        String columnName = this.topLevelFieldName(change.fieldName());
        int index = this.indexOfColumn(columns, columnName);
        if (index == -1) {
            throw new IllegalArgumentException("UpdateColumnNullability does not exist: " + columnName);
        }
        Column existing = columns.get(index);
        columns.set(index, this.rebuildColumn(existing, null, null, null, change.nullable(), null, null));
    }

    private Column rebuildColumn(Column existing, String name, Type dataType, String comment, Boolean nullable, Boolean autoIncrement, Expression defaultValue) {
        return Column.of((String)(name != null ? name : existing.name()), (Type)(dataType != null ? dataType : existing.dataType()), (String)(comment != null ? comment : existing.comment()), (boolean)(nullable != null ? nullable.booleanValue() : existing.nullable()), (boolean)(autoIncrement != null ? autoIncrement.booleanValue() : existing.autoIncrement()), (Expression)(defaultValue != null ? defaultValue : existing.defaultValue()));
    }

    private Expression defaultValueOrUnset(Expression defaultValue) {
        return defaultValue == null ? Column.DEFAULT_VALUE_NOT_SET : defaultValue;
    }

    private String topLevelFieldName(String[] fieldName) {
        Preconditions.checkArgument((fieldName.length == 1 ? 1 : 0) != 0, (Object)"Hive catalog only supports top-level column operations");
        return fieldName[0];
    }

    public boolean dropTable(NameIdentifier tableIdent) {
        try {
            if (this.isExternalTable(tableIdent)) {
                return this.dropHiveTable(tableIdent, false, false);
            }
            return this.dropHiveTable(tableIdent, true, false);
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public boolean purgeTable(NameIdentifier tableIdent) throws UnsupportedOperationException {
        try {
            if (this.isExternalTable(tableIdent)) {
                throw new UnsupportedOperationException("Can't purge a external hive table");
            }
            return this.dropHiveTable(tableIdent, true, true);
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
        try {
            this.clientPool.run(c -> c.getAllDatabases(this.catalogName));
        }
        catch (ConnectionFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionFailedException((Throwable)e, "Failed to run getAllDatabases in Hive Metastore: %s", new Object[]{e.getMessage()});
        }
    }

    private boolean dropHiveTable(NameIdentifier tableIdent, boolean deleteData, boolean ifPurge) {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        try {
            this.clientPool.run(c -> {
                c.dropTable(this.catalogName, schemaIdent.name(), tableIdent.name(), deleteData, ifPurge);
                return null;
            });
            LOG.info("Dropped Hive table {}", (Object)tableIdent.name());
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    CachedClientPool getClientPool() {
        return this.clientPool;
    }

    private boolean isExternalTable(NameIdentifier tableIdent) {
        HiveTableHandle hiveTable = this.loadHiveTable(tableIdent);
        return TableType.EXTERNAL_TABLE.name().equalsIgnoreCase(hiveTable.getTableType());
    }

    private static ThreadFactory getThreadFactory(String factoryName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(factoryName + "-%d").build();
    }
}

