/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.FilesetDispatcher;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchLocationNameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.FileInfo;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetChange;

public class FilesetNormalizeDispatcher
implements FilesetDispatcher {
    private final CatalogManager catalogManager;
    private final FilesetDispatcher dispatcher;

    public FilesetNormalizeDispatcher(FilesetDispatcher dispatcher, CatalogManager catalogManager) {
        this.dispatcher = dispatcher;
        this.catalogManager = catalogManager;
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        Namespace caseSensitiveNs = this.normalizeCaseSensitive(namespace);
        NameIdentifier[] identifiers = this.dispatcher.listFilesets(caseSensitiveNs);
        return this.normalizeCaseSensitive(identifiers);
    }

    @Override
    public FileInfo[] listFiles(NameIdentifier ident, String locationName, String subPath) throws NoSuchFilesetException, IOException {
        return this.dispatcher.listFiles(this.normalizeCaseSensitive(ident), locationName, subPath);
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        return this.dispatcher.loadFileset(this.normalizeCaseSensitive(ident));
    }

    public boolean filesetExists(NameIdentifier ident) {
        return this.dispatcher.filesetExists(this.normalizeCaseSensitive(ident));
    }

    public Fileset createMultipleLocationFileset(NameIdentifier ident, String comment, Fileset.Type type, Map<String, String> storageLocations, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        return this.dispatcher.createMultipleLocationFileset(this.normalizeNameIdentifier(ident), comment, type, storageLocations, properties);
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        Capability capability = CapabilityHelpers.getCapability(ident, this.catalogManager);
        return this.dispatcher.alterFileset(this.normalizeCaseSensitive(ident), CapabilityHelpers.applyCapabilities(capability, changes));
    }

    public boolean dropFileset(NameIdentifier ident) {
        return this.dispatcher.dropFileset(this.normalizeCaseSensitive(ident));
    }

    public String getFileLocation(NameIdentifier ident, String subPath, String locationName) throws NoSuchFilesetException, NoSuchLocationNameException {
        return this.dispatcher.getFileLocation(this.normalizeCaseSensitive(ident), subPath, locationName);
    }

    private NameIdentifier normalizeNameIdentifier(NameIdentifier ident) {
        Capability capabilities = CapabilityHelpers.getCapability(ident, this.catalogManager);
        return CapabilityHelpers.applyCapabilities(ident, Capability.Scope.FILESET, capabilities);
    }

    private Namespace normalizeCaseSensitive(Namespace namespace) {
        Capability capabilities = CapabilityHelpers.getCapability(NameIdentifier.of((String[])namespace.levels()), this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(namespace, Capability.Scope.FILESET, capabilities);
    }

    private NameIdentifier normalizeCaseSensitive(NameIdentifier filesetIdent) {
        Capability capabilities = CapabilityHelpers.getCapability(filesetIdent, this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(filesetIdent, Capability.Scope.FILESET, capabilities);
    }

    private NameIdentifier[] normalizeCaseSensitive(NameIdentifier[] filesetIdents) {
        if (ArrayUtils.isEmpty((Object[])filesetIdents)) {
            return filesetIdents;
        }
        Capability capabilities = CapabilityHelpers.getCapability(filesetIdents[0], this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(filesetIdents, Capability.Scope.FILESET, capabilities);
    }
}

