/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileDeletionBase;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.utils.DataFilePathFactories;
import org.apache.paimon.utils.FileStorePathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagDeletion
extends FileDeletionBase<Snapshot> {
    private static final Logger LOG = LoggerFactory.getLogger(TagDeletion.class);

    public TagDeletion(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler, StatsFileHandler statsFileHandler, boolean cleanEmptyDirectories, int deleteFileThreadNum) {
        super(fileIO, pathFactory, manifestFile, manifestList, indexFileHandler, statsFileHandler, cleanEmptyDirectories, deleteFileThreadNum);
    }

    @Override
    public void cleanUnusedDataFiles(Snapshot taggedSnapshot, Predicate<ExpireFileEntry> skipper) {
        Collection<ExpireFileEntry> manifestEntries;
        try {
            List<ManifestFileMeta> manifests = this.tryReadManifestList(taggedSnapshot.baseManifestList());
            manifests.addAll(this.tryReadManifestList(taggedSnapshot.deltaManifestList()));
            manifestEntries = this.readMergedDataFiles(manifests);
        }
        catch (IOException e) {
            LOG.info("Skip data file clean for the tag of id {}.", (Object)taggedSnapshot.id(), (Object)e);
            return;
        }
        HashSet<Path> dataFileToDelete = new HashSet<Path>();
        DataFilePathFactories factories = new DataFilePathFactories(this.pathFactory);
        for (ExpireFileEntry entry : manifestEntries) {
            DataFilePathFactory dataFilePathFactory = factories.get(entry.partition(), entry.bucket());
            if (skipper.test(entry)) continue;
            dataFileToDelete.add(dataFilePathFactory.toPath(entry));
            for (String file : entry.extraFiles()) {
                dataFileToDelete.add(dataFilePathFactory.toAlignedPath(file, entry));
            }
            this.recordDeletionBuckets(entry);
        }
        this.deleteFiles(dataFileToDelete, arg_0 -> ((FileIO)this.fileIO).deleteQuietly(arg_0));
    }

    @Override
    public void cleanUnusedManifests(Snapshot taggedSnapshot, Set<String> skippingSet) {
        this.cleanUnusedManifests(taggedSnapshot, skippingSet, true, false);
    }

    public Predicate<ExpireFileEntry> dataFileSkipper(List<Snapshot> fromSnapshots) throws Exception {
        HashMap<BinaryRow, Map<Integer, Set<String>>> skipped = new HashMap<BinaryRow, Map<Integer, Set<String>>>();
        for (Snapshot snapshot : fromSnapshots) {
            this.addMergedDataFiles(skipped, snapshot);
        }
        return entry -> this.containsDataFile((Map<BinaryRow, Map<Integer, Set<String>>>)skipped, (ExpireFileEntry)entry);
    }
}

