/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileDeletionBase;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;

public class SnapshotDeletion
extends FileDeletionBase<Snapshot> {
    private final boolean produceChangelog;

    public SnapshotDeletion(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler, StatsFileHandler statsFileHandler, boolean produceChangelog, boolean cleanEmptyDirectories, int deleteFileThreadNum) {
        super(fileIO, pathFactory, manifestFile, manifestList, indexFileHandler, statsFileHandler, cleanEmptyDirectories, deleteFileThreadNum);
        this.produceChangelog = produceChangelog;
    }

    @Override
    public void cleanUnusedDataFiles(Snapshot snapshot, Predicate<ExpireFileEntry> skipper) {
        if (this.changelogDecoupled && !this.produceChangelog) {
            Predicate<ExpireFileEntry> enriched = manifestEntry -> skipper.test((ExpireFileEntry)manifestEntry) || manifestEntry.fileSource().orElse(FileSource.APPEND) == FileSource.APPEND;
            this.cleanUnusedDataFiles(snapshot.deltaManifestList(), enriched);
        } else {
            this.cleanUnusedDataFiles(snapshot.deltaManifestList(), skipper);
        }
    }

    @Override
    public void cleanUnusedManifests(Snapshot snapshot, Set<String> skippingSet) {
        this.cleanUnusedManifests(snapshot, skippingSet, !this.changelogDecoupled || this.produceChangelog, !this.changelogDecoupled);
    }

    @VisibleForTesting
    void cleanUnusedDataFile(List<ExpireFileEntry> dataFileLog) {
        HashMap<Path, Pair<ExpireFileEntry, List<Path>>> dataFileToDelete = new HashMap<Path, Pair<ExpireFileEntry, List<Path>>>();
        this.getDataFileToDelete(dataFileToDelete, dataFileLog);
        this.doCleanUnusedDataFile(dataFileToDelete, f -> false);
    }
}

