/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.serializer.VersionedSerializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageLegacyV2Serializer;
import org.apache.paimon.table.sink.CommitMessageSerializer;

public class ManifestCommittableSerializer
implements VersionedSerializer<ManifestCommittable> {
    private static final int CURRENT_VERSION = 4;
    private final CommitMessageSerializer commitMessageSerializer = new CommitMessageSerializer();
    private CommitMessageLegacyV2Serializer legacyV2CommitMessageSerializer;

    public int getVersion() {
        return 4;
    }

    public byte[] serialize(ManifestCommittable obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        view.writeLong(obj.identifier());
        Long watermark = obj.watermark();
        if (watermark == null) {
            view.writeBoolean(true);
        } else {
            view.writeBoolean(false);
            view.writeLong(watermark.longValue());
        }
        this.serializeOffsets(view, obj.logOffsets());
        this.serializeProperties(view, obj.properties());
        view.writeInt(this.commitMessageSerializer.getVersion());
        this.commitMessageSerializer.serializeList(obj.fileCommittables(), (DataOutputView)view);
        return out.toByteArray();
    }

    private void serializeOffsets(DataOutputViewStreamWrapper view, Map<Integer, Long> offsets) throws IOException {
        view.writeInt(offsets.size());
        for (Map.Entry<Integer, Long> entry : offsets.entrySet()) {
            view.writeInt(entry.getKey().intValue());
            view.writeLong(entry.getValue().longValue());
        }
    }

    private void serializeProperties(DataOutputViewStreamWrapper view, Map<String, String> properties) throws IOException {
        view.writeInt(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            view.writeUTF(entry.getKey());
            view.writeUTF(entry.getValue());
        }
    }

    public ManifestCommittable deserialize(int version, byte[] serialized) throws IOException {
        List<CommitMessage> fileCommittables;
        if (version > 4) {
            throw new UnsupportedOperationException("Expecting ManifestCommittableSerializer version to be smaller or equal than 4, but found " + version + ".");
        }
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        long identifier = view.readLong();
        Long watermark = view.readBoolean() ? null : Long.valueOf(view.readLong());
        Map<Integer, Long> offsets = this.deserializeOffsets(view);
        HashMap<String, String> properties = version == 4 ? this.deserializeProperties(view) : new HashMap();
        int fileCommittableSerializerVersion = view.readInt();
        try {
            fileCommittables = this.commitMessageSerializer.deserializeList(fileCommittableSerializerVersion, (DataInputView)view);
        }
        catch (Exception e) {
            if (fileCommittableSerializerVersion != 2) {
                throw e;
            }
            view = new DataInputDeserializer(serialized);
            view.readLong();
            if (!view.readBoolean()) {
                view.readLong();
            }
            this.deserializeOffsets(view);
            view.readInt();
            if (this.legacyV2CommitMessageSerializer == null) {
                this.legacyV2CommitMessageSerializer = new CommitMessageLegacyV2Serializer();
            }
            fileCommittables = this.legacyV2CommitMessageSerializer.deserializeList((DataInputView)view);
        }
        return new ManifestCommittable(identifier, watermark, offsets, fileCommittables, properties);
    }

    private Map<Integer, Long> deserializeOffsets(DataInputDeserializer view) throws IOException {
        int size = view.readInt();
        HashMap<Integer, Long> offsets = new HashMap<Integer, Long>(size);
        for (int i = 0; i < size; ++i) {
            offsets.put(view.readInt(), view.readLong());
        }
        return offsets;
    }

    private Map<String, String> deserializeProperties(DataInputDeserializer view) throws IOException {
        int size = view.readInt();
        HashMap<String, String> properties = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            properties.put(view.readUTF(), view.readUTF());
        }
        return properties;
    }
}

