/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.apache.twill.internal.state.Message;
import org.apache.twill.internal.state.MessageCodec;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKOperations;
import org.apache.zookeeper.CreateMode;

public final class ZKMessages {
    public static <V> ListenableFuture<V> sendMessage(ZKClient zkClient, String messagePathPrefix, Message message, V completionResult) {
        SettableFuture result = SettableFuture.create();
        ZKMessages.sendMessage(zkClient, messagePathPrefix, message, result, completionResult);
        return result;
    }

    public static <V> void sendMessage(final ZKClient zkClient, String messagePathPrefix, Message message, final SettableFuture<V> completion, final V completionResult) {
        Futures.addCallback((ListenableFuture)zkClient.create(messagePathPrefix, MessageCodec.encode(message), CreateMode.PERSISTENT_SEQUENTIAL), (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(String path) {
                Futures.addCallback((ListenableFuture)ZKOperations.watchDeleted((ZKClient)zkClient, (String)path), (FutureCallback)new FutureCallback<String>(){

                    public void onSuccess(String result) {
                        completion.set(completionResult);
                    }

                    public void onFailure(Throwable t) {
                        completion.setException(t);
                    }
                });
            }

            public void onFailure(Throwable t) {
                completion.setException(t);
            }
        });
    }

    private ZKMessages() {
    }
}

