/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar;

import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.utils.LongIterator;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RecyclableIterator;
import org.apache.paimon.utils.VectorMappingUtils;

public class ColumnarRowIterator
extends RecyclableIterator<InternalRow>
implements FileRecordIterator<InternalRow> {
    protected final Path filePath;
    protected final ColumnarRow row;
    protected final Runnable recycler;
    protected int num;
    protected int index;
    protected int returnedPositionIndex;
    protected long returnedPosition;
    protected LongIterator positionIterator;

    public ColumnarRowIterator(Path filePath, ColumnarRow row, @Nullable Runnable recycler) {
        super(recycler);
        this.filePath = filePath;
        this.row = row;
        this.recycler = recycler;
    }

    public void reset(long nextFilePos) {
        this.reset(LongIterator.fromRange(nextFilePos, nextFilePos + (long)this.row.batch().getNumRows()));
    }

    public void reset(LongIterator positions) {
        this.positionIterator = positions;
        this.num = this.row.batch().getNumRows();
        this.index = 0;
        this.returnedPositionIndex = 0;
        this.returnedPosition = -1L;
    }

    @Override
    @Nullable
    public InternalRow next() {
        if (this.index < this.num) {
            this.row.setRowId(this.index++);
            return this.row;
        }
        return null;
    }

    @Override
    public long returnedPosition() {
        for (int i = 0; i < this.index - this.returnedPositionIndex; ++i) {
            this.returnedPosition = this.positionIterator.next();
        }
        this.returnedPositionIndex = this.index;
        if (this.returnedPosition == -1L) {
            throw new IllegalStateException("returnedPosition() is called before next()");
        }
        return this.returnedPosition;
    }

    @Override
    public Path filePath() {
        return this.filePath;
    }

    protected ColumnarRowIterator copy(ColumnVector[] vectors) {
        Preconditions.checkArgument((this.returnedPositionIndex == 0 ? 1 : 0) != 0, (Object)"copy() should not be called after next()");
        ColumnarRowIterator newIterator = new ColumnarRowIterator(this.filePath, this.row.copy(vectors), this.recycler);
        newIterator.reset(this.positionIterator);
        return newIterator;
    }

    public ColumnarRowIterator mapping(@Nullable PartitionInfo partitionInfo, @Nullable int[] indexMapping) {
        if (partitionInfo != null || indexMapping != null) {
            VectorizedColumnBatch vectorizedColumnBatch = this.row.batch();
            ColumnVector[] vectors = vectorizedColumnBatch.columns;
            if (partitionInfo != null) {
                vectors = VectorMappingUtils.createPartitionMappedVectors(partitionInfo, vectors);
            }
            if (indexMapping != null) {
                vectors = VectorMappingUtils.createMappedVectors(indexMapping, vectors);
            }
            return this.copy(vectors);
        }
        return this;
    }
}

