/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.TopicDispatcher;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.messaging.DataLayout;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicChange;

public class TopicNormalizeDispatcher
implements TopicDispatcher {
    private final CatalogManager catalogManager;
    private final TopicDispatcher dispatcher;

    public TopicNormalizeDispatcher(TopicDispatcher dispatcher, CatalogManager catalogManager) {
        this.dispatcher = dispatcher;
        this.catalogManager = catalogManager;
    }

    public NameIdentifier[] listTopics(Namespace namespace) throws NoSuchSchemaException {
        Namespace caseSensitiveNs = this.normalizeCaseSensitive(namespace);
        NameIdentifier[] identifiers = this.dispatcher.listTopics(caseSensitiveNs);
        return this.normalizeCaseSensitive(identifiers);
    }

    public Topic loadTopic(NameIdentifier ident) throws NoSuchTopicException {
        return this.dispatcher.loadTopic(this.normalizeCaseSensitive(ident));
    }

    public boolean topicExists(NameIdentifier ident) {
        return this.dispatcher.topicExists(this.normalizeCaseSensitive(ident));
    }

    public Topic createTopic(NameIdentifier ident, String comment, DataLayout dataLayout, Map<String, String> properties) throws NoSuchSchemaException, TopicAlreadyExistsException {
        return this.dispatcher.createTopic(this.normalizeNameIdentifier(ident), comment, dataLayout, properties);
    }

    public Topic alterTopic(NameIdentifier ident, TopicChange ... changes) throws NoSuchTopicException, IllegalArgumentException {
        return this.dispatcher.alterTopic(this.normalizeCaseSensitive(ident), changes);
    }

    public boolean dropTopic(NameIdentifier ident) {
        return this.dispatcher.dropTopic(this.normalizeCaseSensitive(ident));
    }

    private Namespace normalizeCaseSensitive(Namespace namespace) {
        Capability capabilities = CapabilityHelpers.getCapability(NameIdentifier.of((String[])namespace.levels()), this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(namespace, Capability.Scope.TOPIC, capabilities);
    }

    private NameIdentifier normalizeCaseSensitive(NameIdentifier topicIdent) {
        Capability capabilities = CapabilityHelpers.getCapability(topicIdent, this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(topicIdent, Capability.Scope.TOPIC, capabilities);
    }

    private NameIdentifier[] normalizeCaseSensitive(NameIdentifier[] topicIdents) {
        if (ArrayUtils.isEmpty((Object[])topicIdents)) {
            return topicIdents;
        }
        Capability capabilities = CapabilityHelpers.getCapability(topicIdents[0], this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(topicIdents, Capability.Scope.TOPIC, capabilities);
    }

    private NameIdentifier normalizeNameIdentifier(NameIdentifier topicIdent) {
        Capability capability = CapabilityHelpers.getCapability(topicIdent, this.catalogManager);
        return CapabilityHelpers.applyCapabilities(topicIdent, Capability.Scope.TOPIC, capability);
    }
}

