/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.UserDefinedType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class StructuredType
extends UserDefinedType {
    private static final long serialVersionUID = 1L;
    public static final String CATALOG_FORMAT = "%s";
    public static final String INLINE_FORMAT = "STRUCTURED<'%s', %s>";
    public static final Class<?> FALLBACK_CONVERSION = Row.class;
    private static final Set<String> INPUT_OUTPUT_CONVERSION = StructuredType.conversionSet(Row.class.getName(), RowData.class.getName());
    private final List<StructuredAttribute> attributes;
    private final boolean isInstantiable;
    private final StructuredComparison comparison;
    @Nullable
    private final StructuredType superType;
    @Nullable
    private final Class<?> implementationClass;
    @Nullable
    private String className;

    private StructuredType(boolean isNullable, ObjectIdentifier objectIdentifier, List<StructuredAttribute> attributes, boolean isFinal, boolean isInstantiable, StructuredComparison comparison, @Nullable StructuredType superType, @Nullable String description, @Nullable String className, @Nullable Class<?> implementationClass) {
        super(isNullable, LogicalTypeRoot.STRUCTURED_TYPE, objectIdentifier, isFinal, description);
        Preconditions.checkArgument((objectIdentifier != null || className != null ? 1 : 0) != 0, (Object)"An identifier is missing.");
        this.attributes = attributes;
        this.isInstantiable = isInstantiable;
        this.comparison = comparison;
        this.superType = superType;
        this.className = StructuredType.checkClassName(className);
        this.implementationClass = implementationClass;
    }

    public static Builder newBuilder(ObjectIdentifier objectIdentifier) {
        return new Builder(objectIdentifier);
    }

    public static Builder newBuilder(ObjectIdentifier objectIdentifier, Class<?> implementationClass) {
        return new Builder(objectIdentifier, implementationClass);
    }

    public static Builder newBuilder(Class<?> implementationClass) {
        return new Builder(implementationClass);
    }

    public static Builder newBuilder(String className) {
        return new Builder(className);
    }

    public List<StructuredAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean isInstantiable() {
        return this.isInstantiable;
    }

    public StructuredComparison getComparison() {
        return this.comparison;
    }

    public Optional<StructuredType> getSuperType() {
        return Optional.ofNullable(this.superType);
    }

    public Optional<String> getClassName() {
        return Optional.ofNullable(this.className);
    }

    public Optional<Class<?>> getImplementationClass() {
        return Optional.ofNullable(this.implementationClass);
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new StructuredType(isNullable, this.getObjectIdentifier().orElse(null), this.attributes, this.isFinal(), this.isInstantiable, this.comparison, this.superType == null ? null : (StructuredType)this.superType.copy(), this.getDescription().orElse(null), this.className, this.implementationClass);
    }

    @Override
    public String asSummaryString() {
        if (this.getObjectIdentifier().isPresent()) {
            return this.asSerializableString();
        }
        assert (this.className != null);
        return this.withNullability(INLINE_FORMAT, this.className, this.getAllAttributes().stream().map(StructuredAttribute::asSummaryString).collect(Collectors.joining(", ")));
    }

    @Override
    public String asSerializableString() {
        String identifier = this.getObjectIdentifier().map(ObjectIdentifier::asSerializableString).orElse(null);
        if (identifier != null) {
            return this.withNullability(CATALOG_FORMAT, identifier);
        }
        assert (this.className != null);
        return this.withNullability(INLINE_FORMAT, EncodingUtils.escapeSingleQuotes(this.className), this.getAllAttributes().stream().map(StructuredAttribute::asSerializableString).collect(Collectors.joining(", ")));
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return this.implementationClass != null && this.implementationClass.isAssignableFrom(clazz) || INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        StructuredType currentType = this;
        while (currentType != null) {
            if (currentType.implementationClass != null && clazz.isAssignableFrom(currentType.implementationClass)) {
                return true;
            }
            currentType = currentType.superType;
        }
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        if (this.implementationClass != null) {
            return this.implementationClass;
        }
        return FALLBACK_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return this.getAllAttributes().stream().map(StructuredAttribute::getType).collect(Collectors.toList());
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructuredType that = (StructuredType)o;
        return this.isInstantiable == that.isInstantiable && this.attributes.equals(that.attributes) && this.comparison == that.comparison && Objects.equals(this.superType, that.superType) && Objects.equals(this.className, that.className);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.attributes, this.isInstantiable, this.comparison, this.superType, this.className});
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getReference() != null) {
            return this;
        }
        return new StructuredType(this.isNullable(), this.getObjectIdentifier().orElse(null), this.attributes, this.isFinal(), this.isInstantiable, StructuredComparison.EQUALS, this.superType, this.getDescription().orElse(null), this.implementationClass != null ? this.implementationClass.getName() : this.className, this.implementationClass);
    }

    private List<StructuredAttribute> getAllAttributes() {
        ArrayList<StructuredAttribute> allAttributes = new ArrayList<StructuredAttribute>();
        if (this.superType != null) {
            allAttributes.addAll(this.superType.getAllAttributes());
        }
        allAttributes.addAll(this.attributes);
        return allAttributes;
    }

    private Object getReference() {
        return this.getObjectIdentifier().map(Object.class::cast).orElse(this.className);
    }

    @Nullable
    private static String checkClassName(@Nullable String className) {
        if (className != null && !SourceVersion.isName(className)) {
            throw new ValidationException(String.format("Invalid class name '%s'. The class name must comply with JVM identifier rules.", className));
        }
        return className;
    }

    public static Optional<Class<?>> resolveClass(ClassLoader classLoader, String className) {
        StructuredType.checkClassName(className);
        try {
            return Optional.of(Class.forName(className, false, classLoader));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    @PublicEvolving
    public static final class Builder {
        @Nullable
        private final ObjectIdentifier objectIdentifier;
        @Nullable
        private final String className;
        @Nullable
        private final Class<?> implementationClass;
        private List<StructuredAttribute> attributes = new ArrayList<StructuredAttribute>();
        private boolean isNullable = true;
        private boolean isFinal = true;
        private boolean isInstantiable = true;
        private StructuredComparison comparison = StructuredComparison.EQUALS;
        @Nullable
        private StructuredType superType;
        @Nullable
        private String description;

        public Builder(String className) {
            this.objectIdentifier = null;
            this.className = (String)Preconditions.checkNotNull((Object)className, (String)"Class name must not be null.");
            this.implementationClass = null;
        }

        public Builder(Class<?> implementationClass) {
            this.objectIdentifier = null;
            this.implementationClass = (Class)Preconditions.checkNotNull(implementationClass, (String)"Implementation class must not be null.");
            this.className = implementationClass.getName();
        }

        public Builder(ObjectIdentifier objectIdentifier) {
            this.objectIdentifier = (ObjectIdentifier)Preconditions.checkNotNull((Object)objectIdentifier, (String)"Object identifier must not be null.");
            this.className = null;
            this.implementationClass = null;
        }

        public Builder(ObjectIdentifier objectIdentifier, Class<?> implementationClass) {
            this.objectIdentifier = (ObjectIdentifier)Preconditions.checkNotNull((Object)objectIdentifier, (String)"Object identifier must not be null.");
            this.implementationClass = (Class)Preconditions.checkNotNull(implementationClass, (String)"Implementation class must not be null.");
            this.className = implementationClass.getName();
        }

        public Builder attributes(List<StructuredAttribute> attributes) {
            this.attributes = List.copyOf((Collection)Preconditions.checkNotNull(attributes, (String)"Attributes must not be null."));
            return this;
        }

        public Builder setNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (String)"Description must not be null.");
            return this;
        }

        public Builder setFinal(boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public Builder setInstantiable(boolean isInstantiable) {
            this.isInstantiable = isInstantiable;
            return this;
        }

        public Builder comparison(StructuredComparison comparison) {
            this.comparison = (StructuredComparison)((Object)Preconditions.checkNotNull((Object)((Object)comparison), (String)"Comparison must not be null."));
            return this;
        }

        public Builder superType(StructuredType superType) {
            this.superType = (StructuredType)Preconditions.checkNotNull((Object)superType, (String)"Super type must not be null.");
            return this;
        }

        public StructuredType build() {
            return new StructuredType(this.isNullable, this.objectIdentifier, this.attributes, this.isFinal, this.isInstantiable, this.comparison, this.superType, this.description, this.className, this.implementationClass);
        }
    }

    @PublicEvolving
    public static enum StructuredComparison {
        EQUALS(true, false),
        FULL(true, true),
        NONE(false, false);

        private final boolean equality;
        private final boolean comparison;

        private StructuredComparison(boolean equality, boolean comparison) {
            this.equality = equality;
            this.comparison = comparison;
        }

        public boolean isEquality() {
            return this.equality;
        }

        public boolean isComparison() {
            return this.comparison;
        }
    }

    @PublicEvolving
    public static final class StructuredAttribute
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String FIELD_FORMAT_WITH_DESCRIPTION = "%s %s '%s'";
        public static final String FIELD_FORMAT_NO_DESCRIPTION = "%s %s";
        private final String name;
        private final LogicalType type;
        @Nullable
        private final String description;

        public StructuredAttribute(String name, LogicalType type, @Nullable String description) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (String)"Attribute name must not be null.");
            this.type = (LogicalType)Preconditions.checkNotNull((Object)type, (String)"Attribute type must not be null.");
            this.description = description;
        }

        public StructuredAttribute(String name, LogicalType type) {
            this(name, type, null);
        }

        public String getName() {
            return this.name;
        }

        public LogicalType getType() {
            return this.type;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public StructuredAttribute copy() {
            return new StructuredAttribute(this.name, this.type.copy(), this.description);
        }

        public String asSummaryString() {
            return this.formatString(this.type.asSummaryString(), true);
        }

        public String asSerializableString() {
            return this.formatString(this.type.asSerializableString(), false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructuredAttribute that = (StructuredAttribute)o;
            return this.name.equals(that.name) && this.type.equals(that.type) && Objects.equals(this.description, that.description);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.description);
        }

        private String formatString(String typeString, boolean excludeDescription) {
            if (this.description == null) {
                return String.format(FIELD_FORMAT_NO_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString);
            }
            if (excludeDescription) {
                return String.format(FIELD_FORMAT_WITH_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString, "...");
            }
            return String.format(FIELD_FORMAT_WITH_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString, EncodingUtils.escapeSingleQuotes(this.description));
        }
    }
}

