/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava33.com.google.common.collect.Streams;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class DescribeModelOperation
implements Operation,
ExecutableOperation {
    private final ObjectIdentifier sqlIdentifier;
    private final boolean isExtended;

    public DescribeModelOperation(ObjectIdentifier sqlIdentifier, boolean isExtended) {
        this.sqlIdentifier = sqlIdentifier;
        this.isExtended = isExtended;
    }

    public ObjectIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.sqlIdentifier);
        params.put("isExtended", this.isExtended);
        return OperationUtils.formatWithChildren("DESCRIBE MODEL", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        Optional<ContextResolvedModel> result = ctx.getCatalogManager().getModel(this.sqlIdentifier);
        if (result.isEmpty()) {
            throw new ValidationException(String.format("Model with the identifier '%s' doesn't exist.", this.sqlIdentifier.asSummaryString()));
        }
        ResolvedSchema inputSchema = result.get().getResolvedModel().getResolvedInputSchema();
        ResolvedSchema outputSchema = result.get().getResolvedModel().getResolvedOutputSchema();
        Object[][] rows = this.generateModelColumnsRows(inputSchema, outputSchema);
        boolean nonComments = this.isSchemaNonColumnComments(inputSchema, outputSchema);
        return TableResultUtils.buildTableResult(this.generateTableColumnsNames(nonComments), this.generateTableColumnsDataTypes(nonComments), rows);
    }

    private Object[][] generateModelColumnsRows(ResolvedSchema inputSchema, ResolvedSchema outputSchema) {
        boolean nonComments = this.isSchemaNonColumnComments(inputSchema, outputSchema);
        return (Object[][])Streams.concat((Stream[])new Stream[]{inputSchema.getColumns().stream().map(c -> this.buildSingleRow((Column)c, nonComments, true)), outputSchema.getColumns().stream().map(c -> this.buildSingleRow((Column)c, nonComments, false))}).toArray(x$0 -> new Object[x$0][]);
    }

    private Object[] buildSingleRow(Column c, boolean nonComments, boolean isInput) {
        LogicalType logicalType = c.getDataType().getLogicalType();
        ArrayList<Serializable> result = new ArrayList<Serializable>(Arrays.asList(c.getName(), logicalType.copy(true).asSummaryString(), logicalType.isNullable(), isInput));
        if (!nonComments) {
            result.add(c.getComment().orElse(null));
        }
        return result.toArray();
    }

    private boolean isSchemaNonColumnComments(ResolvedSchema inputSchema, ResolvedSchema outputSchema) {
        return inputSchema.getColumns().stream().map(Column::getComment).noneMatch(Optional::isPresent) && outputSchema.getColumns().stream().map(Column::getComment).noneMatch(Optional::isPresent);
    }

    private String[] generateTableColumnsNames(boolean nonComments) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList("name", "type", "null", "is input"));
        if (!nonComments) {
            result.add("comment");
        }
        return result.toArray(new String[0]);
    }

    private DataType[] generateTableColumnsDataTypes(boolean nonComments) {
        ArrayList<DataType> result = new ArrayList<DataType>(Arrays.asList(DataTypes.STRING(), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN()));
        if (!nonComments) {
            result.add(DataTypes.STRING());
        }
        return result.toArray(new DataType[0]);
    }
}

