/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.sql.parser.ddl.SqlAlterModelSet;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ModelChange;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterModelChangeOperation;
import org.apache.flink.table.planner.operations.converters.AbstractSqlAlterModelConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public class SqlAlterModelSetConverter
extends AbstractSqlAlterModelConverter<SqlAlterModelSet> {
    @Override
    public Operation convertSqlNode(SqlAlterModelSet sqlAlterModelSet, SqlNodeConverter.ConvertContext context) {
        ResolvedCatalogModel existingModel = this.getExistingModel(context, sqlAlterModelSet.fullModelName(), sqlAlterModelSet.ifModelExists());
        Map<String, String> changeModelOptions = OperationConverterUtils.extractProperties(sqlAlterModelSet.getOptionList());
        if (changeModelOptions.isEmpty()) {
            throw new ValidationException("ALTER MODEL SET does not support empty option.");
        }
        ArrayList modelChanges = new ArrayList();
        changeModelOptions.forEach((key, value) -> modelChanges.add(ModelChange.set((String)key, (String)value)));
        if (existingModel == null) {
            return new AlterModelChangeOperation(context.getCatalogManager().qualifyIdentifier(UnresolvedIdentifier.of((String[])sqlAlterModelSet.fullModelName())), modelChanges, null, sqlAlterModelSet.ifModelExists());
        }
        HashMap<String, String> newOptions = new HashMap<String, String>(existingModel.getOptions());
        newOptions.putAll(changeModelOptions);
        return new AlterModelChangeOperation(context.getCatalogManager().qualifyIdentifier(UnresolvedIdentifier.of((String[])sqlAlterModelSet.fullModelName())), modelChanges, existingModel.copy(newOptions), sqlAlterModelSet.ifModelExists());
    }
}

