/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.metrics.MetricConfig;
import org.influxdb.InfluxDB;

@PublicEvolving
@Documentation.SuffixOption(value="metrics.reporter.influxdb")
public class InfluxdbReporterOptions {
    public static final ConfigOption<String> HOST = ConfigOptions.key((String)"host").stringType().noDefaultValue().withDescription("the InfluxDB server host");
    public static final ConfigOption<Scheme> SCHEME = ConfigOptions.key((String)"scheme").enumType(Scheme.class).defaultValue((Object)Scheme.HTTP).withDescription("the InfluxDB schema");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)8086).withDescription("the InfluxDB server port");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("(optional) InfluxDB username used for authentication");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("(optional) InfluxDB username's password used for authentication");
    public static final ConfigOption<String> DB = ConfigOptions.key((String)"db").stringType().noDefaultValue().withDescription("the InfluxDB database to store metrics");
    public static final ConfigOption<String> RETENTION_POLICY = ConfigOptions.key((String)"retentionPolicy").stringType().defaultValue((Object)"").withDescription("(optional) the InfluxDB retention policy for metrics");
    public static final ConfigOption<InfluxDB.ConsistencyLevel> CONSISTENCY = ConfigOptions.key((String)"consistency").enumType(InfluxDB.ConsistencyLevel.class).defaultValue((Object)InfluxDB.ConsistencyLevel.ONE).withDescription("(optional) the InfluxDB consistency level for metrics");
    public static final ConfigOption<Duration> CONNECT_TIMEOUT = ConfigOptions.key((String)"connectTimeout").durationType().defaultValue((Object)Duration.ofMillis(10000L)).withDescription("(optional) the InfluxDB connect timeout for metrics");
    public static final ConfigOption<Duration> WRITE_TIMEOUT = ConfigOptions.key((String)"writeTimeout").durationType().defaultValue((Object)Duration.ofMillis(10000L)).withDescription("(optional) the InfluxDB write timeout for metrics");

    static String getString(MetricConfig config, ConfigOption<String> key) {
        return config.getString(key.key(), (String)key.defaultValue());
    }

    static int getInteger(MetricConfig config, ConfigOption<Integer> key) {
        return config.getInteger(key.key(), ((Integer)key.defaultValue()).intValue());
    }

    static Duration getDuration(MetricConfig config, ConfigOption<Duration> key) {
        return (Duration)config.getOrDefault((Object)key.key(), key.defaultValue());
    }

    static InfluxDB.ConsistencyLevel getConsistencyLevel(MetricConfig config, ConfigOption<InfluxDB.ConsistencyLevel> key) {
        return InfluxDB.ConsistencyLevel.valueOf(config.getProperty(key.key(), ((InfluxDB.ConsistencyLevel)((Object)key.defaultValue())).name()));
    }

    static Scheme getScheme(MetricConfig config) {
        String value = config.getProperty(SCHEME.key());
        if (value != null) {
            try {
                return (Scheme)((Object)ConfigurationUtils.convertValue((Object)value, Scheme.class));
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalConfigurationException(String.format("Cannot parse the configuration option: %s. Please make sure that you specify a valid value.", SCHEME.key()), (Throwable)iae);
            }
        }
        return (Scheme)((Object)SCHEME.defaultValue());
    }

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https");

        private final String scheme;

        private Scheme(String scheme) {
            this.scheme = scheme;
        }

        public String toString() {
            return this.scheme;
        }
    }
}

