/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchOperations;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;

public class ArrayOfDoublesSketchConstantPostAggregator
extends ArrayOfDoublesSketchPostAggregator {
    private final String value;
    private final ArrayOfDoublesSketch sketchValue;

    @JsonCreator
    public ArrayOfDoublesSketchConstantPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
        super(name);
        Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (Object)"Constant value cannot be null or empty, expecting base64 encoded sketch string");
        this.value = value;
        this.sketchValue = ArrayOfDoublesSketchOperations.deserializeFromBase64EncodedStringSafe(value);
    }

    @Override
    public Set<String> getDependentFields() {
        return Collections.emptySet();
    }

    public Comparator getComparator() {
        return Comparators.alwaysEqual();
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        return this.sketchValue;
    }

    @Override
    public ArrayOfDoublesSketchConstantPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    public ArrayOfDoublesSketch getSketchValue() {
        return this.sketchValue;
    }

    public String toString() {
        return "ArrayOfDoublesSketchConstantPostAggregator{name='" + this.getName() + "', value='" + this.value + "'}";
    }

    @JsonProperty(value="value")
    private String getRawSketchValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayOfDoublesSketchConstantPostAggregator that = (ArrayOfDoublesSketchConstantPostAggregator)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(77).appendString(DigestUtils.sha1Hex((String)this.value)).build();
    }
}

