/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.workqueue.ratelimiter;

import io.kubernetes.client.extended.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ItemFastSlowRateLimiter<T>
implements RateLimiter<T> {
    private Duration fastDelay;
    private Duration slowDelay;
    private int maxFastAttempts;
    private ConcurrentMap<T, AtomicInteger> failures = new ConcurrentHashMap<T, AtomicInteger>();

    public ItemFastSlowRateLimiter(Duration fastDelay, Duration slowDelay, int maxFastAttempts) {
        this.fastDelay = fastDelay;
        this.slowDelay = slowDelay;
        this.maxFastAttempts = maxFastAttempts;
    }

    @Override
    public Duration when(T item) {
        int attempts = this.failures.computeIfAbsent(item, k -> new AtomicInteger()).incrementAndGet();
        if (attempts <= this.maxFastAttempts) {
            return this.fastDelay;
        }
        return this.slowDelay;
    }

    @Override
    public void forget(T item) {
        this.failures.remove(item);
    }

    @Override
    public int numRequeues(T item) {
        return this.failures.computeIfAbsent(item, k -> new AtomicInteger()).get();
    }
}

