/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.logger.Logger;
import org.joda.time.Duration;

public class K8sDiscoveryConfig {
    private static final Logger LOGGER = new Logger(K8sDiscoveryConfig.class);
    public static final Pattern K8S_RESOURCE_NAME_REGEX = Pattern.compile("[a-z0-9][a-z0-9-]*[a-z0-9]");
    @JsonProperty
    @Nonnull
    private final String clusterIdentifier;
    @JsonProperty
    private final String podNameEnvKey;
    @JsonProperty
    private final String podNamespaceEnvKey;
    @JsonProperty
    private final String coordinatorLeaderElectionConfigMapNamespace;
    @JsonProperty
    private final String overlordLeaderElectionConfigMapNamespace;
    @JsonProperty
    private final Duration leaseDuration;
    @JsonProperty
    private final Duration renewDeadline;
    @JsonProperty
    private final Duration retryPeriod;

    @JsonCreator
    public K8sDiscoveryConfig(@JsonProperty(value="clusterIdentifier") String clusterIdentifier, @JsonProperty(value="podNameEnvKey") String podNameEnvKey, @JsonProperty(value="podNamespaceEnvKey") String podNamespaceEnvKey, @JsonProperty(value="coordinatorLeaderElectionConfigMapNamespace") String coordinatorLeaderElectionConfigMapNamespace, @JsonProperty(value="overlordLeaderElectionConfigMapNamespace") String overlordLeaderElectionConfigMapNamespace, @JsonProperty(value="leaseDuration") Duration leaseDuration, @JsonProperty(value="renewDeadline") Duration renewDeadline, @JsonProperty(value="retryPeriod") Duration retryPeriod) {
        Preconditions.checkArgument((clusterIdentifier != null && !clusterIdentifier.isEmpty() ? 1 : 0) != 0, (Object)"null/empty clusterIdentifier");
        Preconditions.checkArgument((boolean)K8S_RESOURCE_NAME_REGEX.matcher(clusterIdentifier).matches(), (String)"clusterIdentifier[%s] is used in k8s resource name and must match regex[%s]", (Object)clusterIdentifier, (Object)K8S_RESOURCE_NAME_REGEX.pattern());
        this.clusterIdentifier = clusterIdentifier;
        this.podNameEnvKey = podNameEnvKey == null ? "POD_NAME" : podNameEnvKey;
        String string = this.podNamespaceEnvKey = podNamespaceEnvKey == null ? "POD_NAMESPACE" : podNamespaceEnvKey;
        if (coordinatorLeaderElectionConfigMapNamespace == null) {
            LOGGER.warn("IF coordinator pods run in multiple namespaces, then you MUST provide coordinatorLeaderElectionConfigMapNamespace", new Object[0]);
        }
        this.coordinatorLeaderElectionConfigMapNamespace = coordinatorLeaderElectionConfigMapNamespace;
        if (overlordLeaderElectionConfigMapNamespace == null) {
            LOGGER.warn("IF overlord pods run in multiple namespaces, then you MUST provide overlordLeaderElectionConfigMapNamespace", new Object[0]);
        }
        this.overlordLeaderElectionConfigMapNamespace = overlordLeaderElectionConfigMapNamespace;
        this.leaseDuration = leaseDuration == null ? Duration.millis((long)60000L) : leaseDuration;
        this.renewDeadline = renewDeadline == null ? Duration.millis((long)17000L) : renewDeadline;
        this.retryPeriod = retryPeriod == null ? Duration.millis((long)5000L) : retryPeriod;
    }

    @JsonProperty
    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    @JsonProperty
    public String getPodNameEnvKey() {
        return this.podNameEnvKey;
    }

    @JsonProperty
    public String getPodNamespaceEnvKey() {
        return this.podNamespaceEnvKey;
    }

    @JsonProperty
    public String getCoordinatorLeaderElectionConfigMapNamespace() {
        return this.coordinatorLeaderElectionConfigMapNamespace;
    }

    @JsonProperty
    public String getOverlordLeaderElectionConfigMapNamespace() {
        return this.overlordLeaderElectionConfigMapNamespace;
    }

    @JsonProperty
    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    @JsonProperty
    public Duration getRenewDeadline() {
        return this.renewDeadline;
    }

    @JsonProperty
    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    public String toString() {
        return "K8sDiscoveryConfig{clusterIdentifier='" + this.clusterIdentifier + "', podNameEnvKey='" + this.podNameEnvKey + "', podNamespaceEnvKey='" + this.podNamespaceEnvKey + "', coordinatorLeaderElectionConfigMapNamespace='" + this.coordinatorLeaderElectionConfigMapNamespace + "', overlordLeaderElectionConfigMapNamespace='" + this.overlordLeaderElectionConfigMapNamespace + "', leaseDuration=" + String.valueOf(this.leaseDuration) + ", renewDeadline=" + String.valueOf(this.renewDeadline) + ", retryPeriod=" + String.valueOf(this.retryPeriod) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        K8sDiscoveryConfig that = (K8sDiscoveryConfig)o;
        return this.clusterIdentifier.equals(that.clusterIdentifier) && Objects.equals(this.podNameEnvKey, that.podNameEnvKey) && Objects.equals(this.podNamespaceEnvKey, that.podNamespaceEnvKey) && Objects.equals(this.coordinatorLeaderElectionConfigMapNamespace, that.coordinatorLeaderElectionConfigMapNamespace) && Objects.equals(this.overlordLeaderElectionConfigMapNamespace, that.overlordLeaderElectionConfigMapNamespace) && Objects.equals(this.leaseDuration, that.leaseDuration) && Objects.equals(this.renewDeadline, that.renewDeadline) && Objects.equals(this.retryPeriod, that.retryPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.clusterIdentifier, this.podNameEnvKey, this.podNamespaceEnvKey, this.coordinatorLeaderElectionConfigMapNamespace, this.overlordLeaderElectionConfigMapNamespace, this.leaseDuration, this.renewDeadline, this.retryPeriod);
    }
}

