/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3.output;

import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.remote.ChunkingStorageConnector;
import org.apache.druid.storage.remote.ChunkingStorageConnectorParameters;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.storage.s3.output.RetryableS3OutputStream;
import org.apache.druid.storage.s3.output.S3OutputConfig;
import org.apache.druid.storage.s3.output.S3UploadManager;

public class S3StorageConnector
extends ChunkingStorageConnector<GetObjectRequest> {
    private static final Logger log = new Logger(S3StorageConnector.class);
    private final S3OutputConfig config;
    private final ServerSideEncryptingAmazonS3 s3Client;
    private final S3UploadManager s3UploadManager;
    static final String DELIM = "/";
    static final Joiner JOINER = Joiner.on((String)"/").skipNulls();
    private static final int MAX_NUMBER_OF_LISTINGS = 1000;

    public S3StorageConnector(S3OutputConfig config, ServerSideEncryptingAmazonS3 serverSideEncryptingAmazonS3, S3UploadManager s3UploadManager) {
        this.config = config;
        this.s3Client = serverSideEncryptingAmazonS3;
        this.s3UploadManager = s3UploadManager;
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull((Object)config.getTempDir(), (Object)"tempDir is null in s3 config");
        try {
            FileUtils.mkdirp((File)config.getTempDir());
        }
        catch (IOException e) {
            throw new RE((Throwable)e, StringUtils.format((String)"Cannot create tempDir : [%s] for s3 storage connector", (Object[])new Object[]{config.getTempDir()}), new Object[0]);
        }
    }

    public boolean pathExists(String path) throws IOException {
        try {
            return (Boolean)S3Utils.retryS3Operation(() -> this.s3Client.doesObjectExist(this.config.getBucket(), this.objectPath(path)), this.config.getMaxRetry());
        }
        catch (Exception e) {
            log.error("Error occurred while checking if file [%s] exists. Error: [%s]", new Object[]{path, e.getMessage()});
            throw new IOException(e);
        }
    }

    public ChunkingStorageConnectorParameters<GetObjectRequest> buildInputParams(String path) {
        long size;
        try {
            size = (Long)S3Utils.retryS3Operation(() -> this.s3Client.getObjectMetadata(this.config.getBucket(), this.objectPath(path)).getInstanceLength(), this.config.getMaxRetry());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.buildInputParams(path, 0L, size);
    }

    public ChunkingStorageConnectorParameters<GetObjectRequest> buildInputParams(String path, long from, long size) {
        ChunkingStorageConnectorParameters.Builder builder = new ChunkingStorageConnectorParameters.Builder();
        builder.start(from);
        builder.end(from + size);
        builder.cloudStoragePath(this.objectPath(path));
        builder.tempDirSupplier(this.config::getTempDir);
        builder.maxRetry(this.config.getMaxRetry());
        builder.retryCondition(S3Utils.S3RETRY);
        builder.objectSupplier((start, end) -> new GetObjectRequest(this.config.getBucket(), this.objectPath(path)).withRange(start, end - 1L));
        builder.objectOpenFunction((ObjectOpenFunction)new ObjectOpenFunction<GetObjectRequest>(){

            public InputStream open(GetObjectRequest object) {
                try {
                    return (InputStream)S3Utils.retryS3Operation(() -> S3StorageConnector.this.s3Client.getObject(object).getObjectContent(), S3StorageConnector.this.config.getMaxRetry());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public InputStream open(GetObjectRequest object, long offset) {
                if (object.getRange() != null) {
                    long[] oldRange = object.getRange();
                    object.setRange(oldRange[0] + offset, oldRange[1]);
                } else {
                    object.setRange(offset);
                }
                return this.open(object);
            }
        });
        return builder.build();
    }

    public OutputStream write(String path) throws IOException {
        return new RetryableS3OutputStream(this.config, this.s3Client, this.objectPath(path), this.s3UploadManager);
    }

    public void deleteFile(String path) throws IOException {
        try {
            String fullPath = this.objectPath(path);
            log.debug("Deleting file at bucket: [%s], path: [%s]", new Object[]{this.config.getBucket(), fullPath});
            S3Utils.retryS3Operation(() -> {
                this.s3Client.deleteObject(this.config.getBucket(), fullPath);
                return null;
            }, this.config.getMaxRetry());
        }
        catch (Exception e) {
            log.error("Error occurred while deleting file at path [%s]. Error: [%s]", new Object[]{path, e.getMessage()});
            throw new IOException(e);
        }
    }

    public void deleteFiles(Iterable<String> paths) throws IOException {
        int currentItemSize = 0;
        ArrayList<DeleteObjectsRequest.KeyVersion> versions = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        for (String path : paths) {
            versions.add(new DeleteObjectsRequest.KeyVersion(this.objectPath(path)));
            if (++currentItemSize != 1000) continue;
            this.deleteKeys(versions);
            versions.clear();
            currentItemSize = 0;
        }
        if (currentItemSize != 0) {
            this.deleteKeys(versions);
        }
    }

    private void deleteKeys(List<DeleteObjectsRequest.KeyVersion> versions) throws IOException {
        try {
            S3Utils.deleteBucketKeys(this.s3Client, this.config.getBucket(), versions, this.config.getMaxRetry());
        }
        catch (Exception e) {
            log.error("Error occurred while deleting files from S3. Error: [%s]", new Object[]{e.getMessage()});
            throw new IOException(e);
        }
    }

    public void deleteRecursively(String dirName) throws IOException {
        try {
            S3Utils.deleteObjectsInPath(this.s3Client, 1000, this.config.getBucket(), this.objectPath(dirName), (Predicate<S3ObjectSummary>)Predicates.alwaysTrue(), this.config.getMaxRetry());
        }
        catch (Exception e) {
            log.error("Error occurred while deleting files in path [%s]. Error: [%s]", new Object[]{dirName, e.getMessage()});
            throw new IOException(e);
        }
    }

    public Iterator<String> listDir(String dirName) throws IOException {
        String prefixBasePath = this.objectPath(dirName);
        try {
            Iterator<S3ObjectSummary> files = S3Utils.objectSummaryIterator(this.s3Client, (Iterable<URI>)ImmutableList.of((Object)new CloudObjectLocation(this.config.getBucket(), prefixBasePath).toUri("s3")), 1000, this.config.getMaxRetry());
            return Iterators.transform(files, summary -> {
                String[] size = summary.getKey().split(prefixBasePath, 2);
                if (size.length > 1) {
                    return size[1];
                }
                return "";
            });
        }
        catch (Exception e) {
            log.error("Error occoured while listing files at path [%s]. Error: [%s]", new Object[]{dirName, e.getMessage()});
            throw new IOException(e);
        }
    }

    @Nonnull
    private String objectPath(String path) {
        return JOINER.join((Object)this.config.getPrefix(), (Object)path, new Object[0]);
    }
}

