/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.Period;

public class KubernetesTaskRunnerConfig {
    @JsonProperty
    @NotNull
    private String namespace;
    @JsonProperty
    private String k8sTaskPodNamePrefix = "";
    @JsonProperty
    private String overlordNamespace = "";
    @JsonProperty
    private boolean debugJobs = false;
    @Deprecated
    @JsonProperty
    private boolean sidecarSupport = false;
    @JsonProperty
    private String primaryContainerName = null;
    @JsonProperty
    private String kubexitImage = "karlkfi/kubexit:v0.3.2";
    private Long graceTerminationPeriodSeconds = null;
    @JsonProperty
    private boolean disableClientProxy;
    @JsonProperty
    @NotNull
    private Period maxTaskDuration = new Period((Object)"PT4H");
    @JsonProperty
    @NotNull
    private Period taskCleanupDelay = new Period((Object)"P2D");
    @JsonProperty
    @NotNull
    private Period taskCleanupInterval = new Period((Object)"PT10m");
    @JsonProperty
    @NotNull
    private Period taskJoinTimeout = new Period((Object)"PT1M");
    @JsonProperty
    @NotNull
    private Period k8sjobLaunchTimeout = new Period((Object)"PT1H");
    @JsonProperty
    @NotNull
    private Period logSaveTimeout = new Period((Object)"PT300S");
    @JsonProperty
    private List<String> peonMonitors = ImmutableList.of();
    @JsonProperty
    @NotNull
    private List<String> javaOptsArray = ImmutableList.of();
    @JsonProperty
    @NotNull
    private int cpuCoreInMicro = 0;
    @JsonProperty
    @NotNull
    private Map<String, String> labels = ImmutableMap.of();
    @JsonProperty
    @NotNull
    private Map<String, String> annotations = ImmutableMap.of();
    @JsonProperty
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    @NotNull
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) @NotNull Integer capacity = Integer.MAX_VALUE;

    public KubernetesTaskRunnerConfig() {
    }

    private KubernetesTaskRunnerConfig(@Nonnull String namespace, String overlordNamespace, String k8sTaskPodNamePrefix, boolean debugJobs, boolean sidecarSupport, String primaryContainerName, String kubexitImage, Long graceTerminationPeriodSeconds, boolean disableClientProxy, Period maxTaskDuration, Period taskCleanupDelay, Period taskCleanupInterval, Period k8sjobLaunchTimeout, Period logSaveTimeout, List<String> peonMonitors, List<String> javaOptsArray, int cpuCoreInMicro, Map<String, String> labels, Map<String, String> annotations, Integer capacity, Period taskJoinTimeout) {
        this.namespace = namespace;
        this.overlordNamespace = (String)ObjectUtils.defaultIfNull((Object)overlordNamespace, (Object)this.overlordNamespace);
        this.k8sTaskPodNamePrefix = k8sTaskPodNamePrefix;
        this.debugJobs = (Boolean)ObjectUtils.defaultIfNull((Object)debugJobs, (Object)this.debugJobs);
        this.sidecarSupport = (Boolean)ObjectUtils.defaultIfNull((Object)sidecarSupport, (Object)this.sidecarSupport);
        this.primaryContainerName = (String)ObjectUtils.defaultIfNull((Object)primaryContainerName, (Object)this.primaryContainerName);
        this.kubexitImage = (String)ObjectUtils.defaultIfNull((Object)kubexitImage, (Object)this.kubexitImage);
        this.graceTerminationPeriodSeconds = (Long)ObjectUtils.defaultIfNull((Object)graceTerminationPeriodSeconds, (Object)this.graceTerminationPeriodSeconds);
        this.disableClientProxy = disableClientProxy;
        this.maxTaskDuration = (Period)ObjectUtils.defaultIfNull((Object)maxTaskDuration, (Object)this.maxTaskDuration);
        this.taskCleanupDelay = (Period)ObjectUtils.defaultIfNull((Object)taskCleanupDelay, (Object)this.taskCleanupDelay);
        this.taskCleanupInterval = (Period)ObjectUtils.defaultIfNull((Object)taskCleanupInterval, (Object)this.taskCleanupInterval);
        this.k8sjobLaunchTimeout = (Period)ObjectUtils.defaultIfNull((Object)k8sjobLaunchTimeout, (Object)this.k8sjobLaunchTimeout);
        this.taskJoinTimeout = (Period)ObjectUtils.defaultIfNull((Object)taskJoinTimeout, (Object)this.taskJoinTimeout);
        this.logSaveTimeout = (Period)ObjectUtils.defaultIfNull((Object)logSaveTimeout, (Object)this.logSaveTimeout);
        this.peonMonitors = (List)ObjectUtils.defaultIfNull(peonMonitors, this.peonMonitors);
        this.javaOptsArray = (List)ObjectUtils.defaultIfNull(javaOptsArray, this.javaOptsArray);
        this.cpuCoreInMicro = (Integer)ObjectUtils.defaultIfNull((Object)cpuCoreInMicro, (Object)this.cpuCoreInMicro);
        this.labels = (Map)ObjectUtils.defaultIfNull(labels, this.labels);
        this.annotations = (Map)ObjectUtils.defaultIfNull(annotations, this.annotations);
        this.capacity = (Integer)ObjectUtils.defaultIfNull((Object)capacity, (Object)this.capacity);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getOverlordNamespace() {
        return this.overlordNamespace;
    }

    public String getK8sTaskPodNamePrefix() {
        return this.k8sTaskPodNamePrefix;
    }

    public boolean isDebugJobs() {
        return this.debugJobs;
    }

    @Deprecated
    public boolean isSidecarSupport() {
        return this.sidecarSupport;
    }

    public String getPrimaryContainerName() {
        return this.primaryContainerName;
    }

    public String getKubexitImage() {
        return this.kubexitImage;
    }

    public Long getGraceTerminationPeriodSeconds() {
        return this.graceTerminationPeriodSeconds;
    }

    public boolean isDisableClientProxy() {
        return this.disableClientProxy;
    }

    public Period getTaskTimeout() {
        return this.maxTaskDuration;
    }

    public Period getTaskJoinTimeout() {
        return this.taskJoinTimeout;
    }

    public Period getTaskCleanupDelay() {
        return this.taskCleanupDelay;
    }

    public Period getTaskCleanupInterval() {
        return this.taskCleanupInterval;
    }

    public Period getTaskLaunchTimeout() {
        return this.k8sjobLaunchTimeout;
    }

    public Period getLogSaveTimeout() {
        return this.logSaveTimeout;
    }

    public List<String> getPeonMonitors() {
        return this.peonMonitors;
    }

    public List<String> getJavaOptsArray() {
        return this.javaOptsArray;
    }

    public int getCpuCoreInMicro() {
        return this.cpuCoreInMicro;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String namespace;
        private String overlordNamespace;
        private String k8sTaskPodNamePrefix;
        private boolean debugJob;
        private boolean sidecarSupport;
        private String primaryContainerName;
        private String kubexitImage;
        private Long graceTerminationPeriodSeconds;
        private boolean disableClientProxy;
        private Period maxTaskDuration;
        private Period taskCleanupDelay;
        private Period taskCleanupInterval;
        private Period k8sjobLaunchTimeout;
        private List<String> peonMonitors;
        private List<String> javaOptsArray;
        private int cpuCoreInMicro;
        private Map<String, String> labels;
        private Map<String, String> annotations;
        private Integer capacity;
        private Period taskJoinTimeout;
        private Period logSaveTimeout;

        public Builder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder withOverlordNamespace(String overlordNamespace) {
            this.overlordNamespace = overlordNamespace;
            return this;
        }

        public Builder withK8sTaskPodNamePrefix(String k8sTaskPodNamePrefix) {
            this.k8sTaskPodNamePrefix = k8sTaskPodNamePrefix;
            return this;
        }

        public Builder withDebugJob(boolean debugJob) {
            this.debugJob = debugJob;
            return this;
        }

        public Builder withSidecarSupport(boolean sidecarSupport) {
            this.sidecarSupport = sidecarSupport;
            return this;
        }

        public Builder withPrimaryContainerName(String primaryContainerName) {
            this.primaryContainerName = primaryContainerName;
            return this;
        }

        public Builder withKubexitImage(String kubexitImage) {
            this.kubexitImage = kubexitImage;
            return this;
        }

        public Builder withGraceTerminationPeriodSeconds(Long graceTerminationPeriodSeconds) {
            this.graceTerminationPeriodSeconds = graceTerminationPeriodSeconds;
            return this;
        }

        public Builder withDisableClientProxy(boolean disableClientProxy) {
            this.disableClientProxy = disableClientProxy;
            return this;
        }

        public Builder withTaskTimeout(Period taskTimeout) {
            this.maxTaskDuration = taskTimeout;
            return this;
        }

        public Builder withTaskCleanupDelay(Period taskCleanupDelay) {
            this.taskCleanupDelay = taskCleanupDelay;
            return this;
        }

        public Builder withTaskCleanupInterval(Period taskCleanupInterval) {
            this.taskCleanupInterval = taskCleanupInterval;
            return this;
        }

        public Builder withK8sJobLaunchTimeout(Period k8sjobLaunchTimeout) {
            this.k8sjobLaunchTimeout = k8sjobLaunchTimeout;
            return this;
        }

        public Builder withPeonMonitors(List<String> peonMonitors) {
            this.peonMonitors = peonMonitors;
            return this;
        }

        public Builder withCpuCore(int cpuCore) {
            this.cpuCoreInMicro = cpuCore;
            return this;
        }

        public Builder withJavaOptsArray(List<String> javaOptsArray) {
            this.javaOptsArray = javaOptsArray;
            return this;
        }

        public Builder withLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder withAnnotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder withCapacity(@Min(value=0L) @Max(value=0x7FFFFFFFL) @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder withTaskJoinTimeout(Period taskJoinTimeout) {
            this.taskJoinTimeout = taskJoinTimeout;
            return this;
        }

        public Builder withLogSaveTimeout(Period logSaveTimeout) {
            this.logSaveTimeout = logSaveTimeout;
            return this;
        }

        public KubernetesTaskRunnerConfig build() {
            return new KubernetesTaskRunnerConfig(this.namespace, this.overlordNamespace, this.k8sTaskPodNamePrefix, this.debugJob, this.sidecarSupport, this.primaryContainerName, this.kubexitImage, this.graceTerminationPeriodSeconds, this.disableClientProxy, this.maxTaskDuration, this.taskCleanupDelay, this.taskCleanupInterval, this.k8sjobLaunchTimeout, this.logSaveTimeout, this.peonMonitors, this.javaOptsArray, this.cpuCoreInMicro, this.labels, this.annotations, this.capacity, this.taskJoinTimeout);
        }
    }
}

