/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.fluent.ConnectionMonitorsClient;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorResultInner;
import com.azure.resourcemanager.network.implementation.ConnectionMonitorImpl;
import com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.azure.resourcemanager.network.models.ConnectionMonitor;
import com.azure.resourcemanager.network.models.ConnectionMonitors;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import reactor.core.publisher.Mono;

class ConnectionMonitorsImpl
extends CreatableResourcesImpl<ConnectionMonitor, ConnectionMonitorImpl, ConnectionMonitorResultInner>
implements ConnectionMonitors {
    private final NetworkWatcherImpl parent;
    private final ConnectionMonitorsClient innerCollection;

    ConnectionMonitorsImpl(ConnectionMonitorsClient innerCollection, NetworkWatcherImpl parent) {
        this.parent = parent;
        this.innerCollection = innerCollection;
    }

    public final PagedIterable<ConnectionMonitor> list() {
        return this.wrapList(this.inner().list(this.parent.resourceGroupName(), this.parent.name()));
    }

    public PagedFlux<ConnectionMonitor> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync(this.parent.resourceGroupName(), this.parent.name()));
    }

    protected ConnectionMonitorImpl wrapModel(String name) {
        return new ConnectionMonitorImpl(name, this.parent, new ConnectionMonitorResultInner(), this.inner());
    }

    protected ConnectionMonitorImpl wrapModel(ConnectionMonitorResultInner inner) {
        return inner == null ? null : new ConnectionMonitorImpl(inner.name(), this.parent, inner, this.inner());
    }

    public ConnectionMonitorImpl define(String name) {
        return new ConnectionMonitorImpl(name, this.parent, new ConnectionMonitorResultInner(), this.inner());
    }

    public Mono<ConnectionMonitor> getByNameAsync(String name) {
        return this.inner().getAsync(this.parent.resourceGroupName(), this.parent.name(), name).map(inner -> this.wrapModel((ConnectionMonitorResultInner)((Object)inner)));
    }

    public ConnectionMonitor getByName(String name) {
        return (ConnectionMonitor)this.getByNameAsync(name).block();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public ConnectionMonitorsClient inner() {
        return this.innerCollection;
    }

    public Mono<Void> deleteByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().deleteAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }
}

