/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describe a container image")
public class V1ContainerImage {
    public static final String SERIALIZED_NAME_NAMES = "names";
    @SerializedName(value="names")
    private List<String> names = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SIZE_BYTES = "sizeBytes";
    @SerializedName(value="sizeBytes")
    private Long sizeBytes;

    public V1ContainerImage names(List<String> names) {
        this.names = names;
        return this;
    }

    public V1ContainerImage addNamesItem(String namesItem) {
        this.names.add(namesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Names by which this image is known. e.g. [\"k8s.gcr.io/hyperkube:v1.0.7\", \"dockerhub.io/google_containers/hyperkube:v1.0.7\"]")
    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public V1ContainerImage sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size of the image in bytes.")
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerImage v1ContainerImage = (V1ContainerImage)o;
        return Objects.equals(this.names, v1ContainerImage.names) && Objects.equals(this.sizeBytes, v1ContainerImage.sizeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.names, this.sizeBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerImage {\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

