/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.AppSpecification;
import com.amazonaws.services.sagemaker.model.ExperimentConfig;
import com.amazonaws.services.sagemaker.model.NetworkConfig;
import com.amazonaws.services.sagemaker.model.ProcessingInput;
import com.amazonaws.services.sagemaker.model.ProcessingOutputConfig;
import com.amazonaws.services.sagemaker.model.ProcessingResources;
import com.amazonaws.services.sagemaker.model.ProcessingStoppingCondition;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateProcessingJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<ProcessingInput> processingInputs;
    private ProcessingOutputConfig processingOutputConfig;
    private String processingJobName;
    private ProcessingResources processingResources;
    private ProcessingStoppingCondition stoppingCondition;
    private AppSpecification appSpecification;
    private Map<String, String> environment;
    private NetworkConfig networkConfig;
    private String roleArn;
    private List<Tag> tags;
    private ExperimentConfig experimentConfig;

    public List<ProcessingInput> getProcessingInputs() {
        return this.processingInputs;
    }

    public void setProcessingInputs(Collection<ProcessingInput> processingInputs) {
        if (processingInputs == null) {
            this.processingInputs = null;
            return;
        }
        this.processingInputs = new ArrayList<ProcessingInput>(processingInputs);
    }

    public CreateProcessingJobRequest withProcessingInputs(ProcessingInput ... processingInputs) {
        if (this.processingInputs == null) {
            this.setProcessingInputs(new ArrayList<ProcessingInput>(processingInputs.length));
        }
        for (ProcessingInput ele : processingInputs) {
            this.processingInputs.add(ele);
        }
        return this;
    }

    public CreateProcessingJobRequest withProcessingInputs(Collection<ProcessingInput> processingInputs) {
        this.setProcessingInputs(processingInputs);
        return this;
    }

    public void setProcessingOutputConfig(ProcessingOutputConfig processingOutputConfig) {
        this.processingOutputConfig = processingOutputConfig;
    }

    public ProcessingOutputConfig getProcessingOutputConfig() {
        return this.processingOutputConfig;
    }

    public CreateProcessingJobRequest withProcessingOutputConfig(ProcessingOutputConfig processingOutputConfig) {
        this.setProcessingOutputConfig(processingOutputConfig);
        return this;
    }

    public void setProcessingJobName(String processingJobName) {
        this.processingJobName = processingJobName;
    }

    public String getProcessingJobName() {
        return this.processingJobName;
    }

    public CreateProcessingJobRequest withProcessingJobName(String processingJobName) {
        this.setProcessingJobName(processingJobName);
        return this;
    }

    public void setProcessingResources(ProcessingResources processingResources) {
        this.processingResources = processingResources;
    }

    public ProcessingResources getProcessingResources() {
        return this.processingResources;
    }

    public CreateProcessingJobRequest withProcessingResources(ProcessingResources processingResources) {
        this.setProcessingResources(processingResources);
        return this;
    }

    public void setStoppingCondition(ProcessingStoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public ProcessingStoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public CreateProcessingJobRequest withStoppingCondition(ProcessingStoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public void setAppSpecification(AppSpecification appSpecification) {
        this.appSpecification = appSpecification;
    }

    public AppSpecification getAppSpecification() {
        return this.appSpecification;
    }

    public CreateProcessingJobRequest withAppSpecification(AppSpecification appSpecification) {
        this.setAppSpecification(appSpecification);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public CreateProcessingJobRequest withEnvironment(Map<String, String> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public CreateProcessingJobRequest addEnvironmentEntry(String key, String value) {
        if (null == this.environment) {
            this.environment = new HashMap<String, String>();
        }
        if (this.environment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environment.put(key, value);
        return this;
    }

    public CreateProcessingJobRequest clearEnvironmentEntries() {
        this.environment = null;
        return this;
    }

    public void setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public CreateProcessingJobRequest withNetworkConfig(NetworkConfig networkConfig) {
        this.setNetworkConfig(networkConfig);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateProcessingJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateProcessingJobRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateProcessingJobRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setExperimentConfig(ExperimentConfig experimentConfig) {
        this.experimentConfig = experimentConfig;
    }

    public ExperimentConfig getExperimentConfig() {
        return this.experimentConfig;
    }

    public CreateProcessingJobRequest withExperimentConfig(ExperimentConfig experimentConfig) {
        this.setExperimentConfig(experimentConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProcessingInputs() != null) {
            sb.append("ProcessingInputs: ").append(this.getProcessingInputs()).append(",");
        }
        if (this.getProcessingOutputConfig() != null) {
            sb.append("ProcessingOutputConfig: ").append(this.getProcessingOutputConfig()).append(",");
        }
        if (this.getProcessingJobName() != null) {
            sb.append("ProcessingJobName: ").append(this.getProcessingJobName()).append(",");
        }
        if (this.getProcessingResources() != null) {
            sb.append("ProcessingResources: ").append(this.getProcessingResources()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition()).append(",");
        }
        if (this.getAppSpecification() != null) {
            sb.append("AppSpecification: ").append(this.getAppSpecification()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getNetworkConfig() != null) {
            sb.append("NetworkConfig: ").append(this.getNetworkConfig()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getExperimentConfig() != null) {
            sb.append("ExperimentConfig: ").append(this.getExperimentConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProcessingJobRequest)) {
            return false;
        }
        CreateProcessingJobRequest other = (CreateProcessingJobRequest)obj;
        if (other.getProcessingInputs() == null ^ this.getProcessingInputs() == null) {
            return false;
        }
        if (other.getProcessingInputs() != null && !other.getProcessingInputs().equals(this.getProcessingInputs())) {
            return false;
        }
        if (other.getProcessingOutputConfig() == null ^ this.getProcessingOutputConfig() == null) {
            return false;
        }
        if (other.getProcessingOutputConfig() != null && !other.getProcessingOutputConfig().equals(this.getProcessingOutputConfig())) {
            return false;
        }
        if (other.getProcessingJobName() == null ^ this.getProcessingJobName() == null) {
            return false;
        }
        if (other.getProcessingJobName() != null && !other.getProcessingJobName().equals(this.getProcessingJobName())) {
            return false;
        }
        if (other.getProcessingResources() == null ^ this.getProcessingResources() == null) {
            return false;
        }
        if (other.getProcessingResources() != null && !other.getProcessingResources().equals(this.getProcessingResources())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        if (other.getStoppingCondition() != null && !other.getStoppingCondition().equals(this.getStoppingCondition())) {
            return false;
        }
        if (other.getAppSpecification() == null ^ this.getAppSpecification() == null) {
            return false;
        }
        if (other.getAppSpecification() != null && !other.getAppSpecification().equals(this.getAppSpecification())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getNetworkConfig() == null ^ this.getNetworkConfig() == null) {
            return false;
        }
        if (other.getNetworkConfig() != null && !other.getNetworkConfig().equals(this.getNetworkConfig())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getExperimentConfig() == null ^ this.getExperimentConfig() == null) {
            return false;
        }
        return other.getExperimentConfig() == null || other.getExperimentConfig().equals(this.getExperimentConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProcessingInputs() == null ? 0 : this.getProcessingInputs().hashCode());
        hashCode = 31 * hashCode + (this.getProcessingOutputConfig() == null ? 0 : this.getProcessingOutputConfig().hashCode());
        hashCode = 31 * hashCode + (this.getProcessingJobName() == null ? 0 : this.getProcessingJobName().hashCode());
        hashCode = 31 * hashCode + (this.getProcessingResources() == null ? 0 : this.getProcessingResources().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        hashCode = 31 * hashCode + (this.getAppSpecification() == null ? 0 : this.getAppSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfig() == null ? 0 : this.getNetworkConfig().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getExperimentConfig() == null ? 0 : this.getExperimentConfig().hashCode());
        return hashCode;
    }

    public CreateProcessingJobRequest clone() {
        return (CreateProcessingJobRequest)super.clone();
    }
}

