/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.fluent.models.InitContainerPropertiesDefinition;
import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.InitContainerPropertiesDefinitionInstanceView;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class InitContainerDefinition {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties", required=true)
    private InitContainerPropertiesDefinition innerProperties = new InitContainerPropertiesDefinition();
    private static final ClientLogger LOGGER = new ClientLogger(InitContainerDefinition.class);

    public String name() {
        return this.name;
    }

    public InitContainerDefinition withName(String name) {
        this.name = name;
        return this;
    }

    private InitContainerPropertiesDefinition innerProperties() {
        return this.innerProperties;
    }

    public String image() {
        return this.innerProperties() == null ? null : this.innerProperties().image();
    }

    public InitContainerDefinition withImage(String image) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withImage(image);
        return this;
    }

    public List<String> command() {
        return this.innerProperties() == null ? null : this.innerProperties().command();
    }

    public InitContainerDefinition withCommand(List<String> command) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withCommand(command);
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentVariables();
    }

    public InitContainerDefinition withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withEnvironmentVariables(environmentVariables);
        return this;
    }

    public InitContainerPropertiesDefinitionInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public List<VolumeMount> volumeMounts() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeMounts();
    }

    public InitContainerDefinition withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withVolumeMounts(volumeMounts);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model InitContainerDefinition"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model InitContainerDefinition"));
        }
        this.innerProperties().validate();
    }
}

