/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.dolphinscheduler.common.config.IPropertyDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class ImmutableYamlDelegate
implements IPropertyDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImmutableYamlDelegate.class);
    private static final String REMOTE_LOGGING_YAML_NAME = "/remote-logging.yaml";
    private final Properties properties;

    public ImmutableYamlDelegate() {
        this(REMOTE_LOGGING_YAML_NAME);
    }

    public ImmutableYamlDelegate(String ... yamlAbsolutePath) {
        this.properties = new Properties();
        for (String fileName : yamlAbsolutePath) {
            try (InputStream fis = ImmutableYamlDelegate.class.getResourceAsStream(fileName);){
                if (fis == null) {
                    log.warn("Cannot find the file: {} under classpath", (Object)fileName);
                    continue;
                }
                YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
                factory.setResources(new Resource[]{new InputStreamResource(fis)});
                factory.afterPropertiesSet();
                Properties subProperties = factory.getObject();
                this.properties.putAll((Map<?, ?>)subProperties);
            }
            catch (IOException e) {
                log.error("Load property: {} error, please check if the file exist under classpath", (Object)yamlAbsolutePath, (Object)e);
                throw new RuntimeException(e);
            }
        }
        this.printProperties();
    }

    public ImmutableYamlDelegate(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String get(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.properties.stringPropertyNames();
    }

    private void printProperties() {
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> log.debug("Get property {} -> {}", k, v)));
    }
}

