/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedVirtualNetworkResourceInner;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.ManagedVirtualNetwork;
import com.azure.resourcemanager.datafactory.models.ManagedVirtualNetworkResource;

public final class ManagedVirtualNetworkResourceImpl
implements ManagedVirtualNetworkResource,
ManagedVirtualNetworkResource.Definition,
ManagedVirtualNetworkResource.Update {
    private ManagedVirtualNetworkResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String managedVirtualNetworkName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public ManagedVirtualNetwork properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedVirtualNetworkResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedVirtualNetworkResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public ManagedVirtualNetworkResource create() {
        this.innerObject = (ManagedVirtualNetworkResourceInner)((Object)this.serviceManager.serviceClient().getManagedVirtualNetworks().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedVirtualNetworkResource create(Context context) {
        this.innerObject = (ManagedVirtualNetworkResourceInner)((Object)this.serviceManager.serviceClient().getManagedVirtualNetworks().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    ManagedVirtualNetworkResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new ManagedVirtualNetworkResourceInner();
        this.serviceManager = serviceManager;
        this.managedVirtualNetworkName = name;
        this.createIfMatch = null;
    }

    @Override
    public ManagedVirtualNetworkResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public ManagedVirtualNetworkResource apply() {
        this.innerObject = (ManagedVirtualNetworkResourceInner)((Object)this.serviceManager.serviceClient().getManagedVirtualNetworks().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedVirtualNetworkResource apply(Context context) {
        this.innerObject = (ManagedVirtualNetworkResourceInner)((Object)this.serviceManager.serviceClient().getManagedVirtualNetworks().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    ManagedVirtualNetworkResourceImpl(ManagedVirtualNetworkResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = Utils.getValueFromIdByName(innerObject.id(), "factories");
        this.managedVirtualNetworkName = Utils.getValueFromIdByName(innerObject.id(), "managedVirtualNetworks");
    }

    @Override
    public ManagedVirtualNetworkResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (ManagedVirtualNetworkResourceInner)((Object)this.serviceManager.serviceClient().getManagedVirtualNetworks().getWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedVirtualNetworkResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (ManagedVirtualNetworkResourceInner)((Object)this.serviceManager.serviceClient().getManagedVirtualNetworks().getWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public ManagedVirtualNetworkResourceImpl withProperties(ManagedVirtualNetwork properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ManagedVirtualNetworkResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

