/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.graph;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowGraph;

public class WorkflowGraph
implements IWorkflowGraph {
    private final Map<Long, TaskDefinition> taskDefinitionCodeMap;
    private final Map<String, TaskDefinition> taskDefinitionMap;
    private final Map<String, List<String>> predecessors;
    private final Map<String, List<String>> successors;

    public WorkflowGraph(List<WorkflowTaskRelation> workflowTaskRelations, List<TaskDefinition> taskDefinitions) {
        Preconditions.checkNotNull(taskDefinitions, (Object)"taskDefinitions can not be null");
        Preconditions.checkNotNull(workflowTaskRelations, (Object)"taskDefinitions can not be null");
        this.predecessors = new HashMap<String, List<String>>();
        this.successors = new HashMap<String, List<String>>();
        this.taskDefinitionMap = taskDefinitions.stream().collect(Collectors.toMap(TaskDefinition::getName, Function.identity()));
        this.taskDefinitionCodeMap = taskDefinitions.stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity()));
        this.addTaskNodes(taskDefinitions);
        this.addTaskEdge(workflowTaskRelations);
    }

    @Override
    public List<String> getStartNodes() {
        return this.predecessors.entrySet().stream().filter(entry -> ((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public Set<String> getPredecessors(String taskName) {
        return new HashSet<String>((Collection)this.predecessors.get(taskName));
    }

    @Override
    public Set<String> getSuccessors(String taskName) {
        return new HashSet<String>((Collection)this.successors.get(taskName));
    }

    @Override
    public TaskDefinition getTaskNodeByName(String taskName) {
        TaskDefinition taskDefinition = this.taskDefinitionMap.get(taskName);
        if (taskDefinition == null) {
            throw new IllegalArgumentException("Cannot find task: " + taskName);
        }
        return taskDefinition;
    }

    @Override
    public TaskDefinition getTaskNodeByCode(Long taskCode) {
        TaskDefinition taskDefinition = this.taskDefinitionCodeMap.get(taskCode);
        if (taskDefinition == null) {
            throw new IllegalArgumentException("Cannot find task: " + taskCode);
        }
        return taskDefinition;
    }

    @Override
    public List<TaskDefinition> getAllTaskNodes() {
        return new ArrayList<TaskDefinition>(this.taskDefinitionMap.values());
    }

    private void addTaskNodes(List<TaskDefinition> taskDefinitions) {
        taskDefinitions.stream().map(TaskDefinition::getName).forEach(taskDefinition -> {
            if (this.predecessors.containsKey(taskDefinition) || this.successors.containsKey(taskDefinition)) {
                throw new IllegalArgumentException("The task " + taskDefinition + " is already exists");
            }
            this.predecessors.put((String)taskDefinition, new ArrayList());
            this.successors.put((String)taskDefinition, new ArrayList());
        });
    }

    private void addTaskEdge(List<WorkflowTaskRelation> workflowTaskRelations) {
        for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelations) {
            long pre = workflowTaskRelation.getPreTaskCode();
            long post = workflowTaskRelation.getPostTaskCode();
            if (pre > 0L && post > 0L) {
                if (!this.taskDefinitionCodeMap.containsKey(pre)) {
                    throw new IllegalArgumentException("Cannot find task: " + pre);
                }
                if (!this.taskDefinitionCodeMap.containsKey(post)) {
                    throw new IllegalArgumentException("Cannot find task: " + post);
                }
                TaskDefinition preTask = (TaskDefinition)Preconditions.checkNotNull((Object)this.taskDefinitionCodeMap.get(pre), (Object)("Cannot find task: " + pre));
                TaskDefinition postTask = (TaskDefinition)Preconditions.checkNotNull((Object)this.taskDefinitionCodeMap.get(post), (Object)("Cannot find task: " + pre));
                List<String> predecessorsTasks = this.predecessors.get(postTask.getName());
                if (predecessorsTasks.contains(preTask.getName())) {
                    throw new IllegalArgumentException("The task relation from " + preTask.getName() + " to " + postTask.getName() + " is already exists");
                }
                predecessorsTasks.add(preTask.getName());
                List<String> successTasks = this.successors.get(preTask.getName());
                if (successTasks.contains(postTask.getName())) {
                    throw new IllegalArgumentException("The task relation from " + preTask.getName() + " to " + postTask.getName() + " is already exists");
                }
                successTasks.add(postTask.getName());
            }
            if (pre > 0L || post > 0L) continue;
            throw new IllegalArgumentException("The task relation from " + pre + " to " + post + " is invalid");
        }
    }
}

