/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.FeatureGroup;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class FeatureGroupMarshaller {
    private static final MarshallingInfo<String> FEATUREGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureGroupArn").build();
    private static final MarshallingInfo<String> FEATUREGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureGroupName").build();
    private static final MarshallingInfo<String> RECORDIDENTIFIERFEATURENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordIdentifierFeatureName").build();
    private static final MarshallingInfo<String> EVENTTIMEFEATURENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventTimeFeatureName").build();
    private static final MarshallingInfo<List> FEATUREDEFINITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureDefinitions").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> ONLINESTORECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OnlineStoreConfig").build();
    private static final MarshallingInfo<StructuredPojo> OFFLINESTORECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OfflineStoreConfig").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<String> FEATUREGROUPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureGroupStatus").build();
    private static final MarshallingInfo<StructuredPojo> OFFLINESTORESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OfflineStoreStatus").build();
    private static final MarshallingInfo<StructuredPojo> LASTUPDATESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateStatus").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final FeatureGroupMarshaller instance = new FeatureGroupMarshaller();

    public static FeatureGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(FeatureGroup featureGroup, ProtocolMarshaller protocolMarshaller) {
        if (featureGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)featureGroup.getFeatureGroupArn(), FEATUREGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getFeatureGroupName(), FEATUREGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getRecordIdentifierFeatureName(), RECORDIDENTIFIERFEATURENAME_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getEventTimeFeatureName(), EVENTTIMEFEATURENAME_BINDING);
            protocolMarshaller.marshall(featureGroup.getFeatureDefinitions(), FEATUREDEFINITIONS_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getOnlineStoreConfig(), ONLINESTORECONFIG_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getOfflineStoreConfig(), OFFLINESTORECONFIG_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getFeatureGroupStatus(), FEATUREGROUPSTATUS_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getOfflineStoreStatus(), OFFLINESTORESTATUS_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getLastUpdateStatus(), LASTUPDATESTATUS_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)featureGroup.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(featureGroup.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

