/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourceCollectionImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ExternalChildResourcesCachedImpl<FluentModelTImpl extends ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT>, FluentModelT extends ExternalChildResource<FluentModelT, ParentT>, InnerModelT, ParentImplT extends ParentT, ParentT>
extends ExternalChildResourceCollectionImpl<FluentModelTImpl, FluentModelT, InnerModelT, ParentImplT, ParentT> {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private static final String ERROR_MESSAGE_FORMAT = "A child resource ('%s') with name (key) '%s (%s)' %s";

    protected ExternalChildResourcesCachedImpl(ParentImplT parent, TaskGroup parentTaskGroup, String childResourceName) {
        super(parent, parentTaskGroup, childResourceName);
    }

    public Mono<Void> refreshAsync() {
        return this.cacheCollectionAsync();
    }

    public void refresh() {
        this.cacheCollection();
    }

    protected Map<String, FluentModelTImpl> collection() {
        return this.childCollection;
    }

    protected final FluentModelTImpl prepareIndependentDefine(String name) {
        FluentModelTImpl childResource = this.newChildResource(name);
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return childResource;
    }

    protected FluentModelTImpl prepareInlineDefine(String name) {
        return this.prepareInlineDefine(name, name);
    }

    protected final FluentModelTImpl prepareInlineDefine(String name, String key) {
        if (this.find(key) != null) {
            String errorMessage = String.format(ERROR_MESSAGE_FORMAT, this.childResourceName, name, key, "already exists");
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(errorMessage));
        }
        FluentModelTImpl childResource = this.newChildResource(name);
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return super.prepareForFutureCommitOrPostRun(childResource);
    }

    protected final FluentModelTImpl prepareInlineUpdate(String name) {
        return this.prepareInlineUpdate(name, name);
    }

    protected final FluentModelTImpl prepareInlineUpdate(String name, String key) {
        Object childResource = this.find(key);
        if (childResource == null || ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated) {
            String errorMessage = String.format(ERROR_MESSAGE_FORMAT, this.childResourceName, name, key, "not found");
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(errorMessage));
        }
        if (((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeRemoved) {
            String errorMessage = String.format(ERROR_MESSAGE_FORMAT, this.childResourceName, name, key, "is marked for deletion");
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(errorMessage));
        }
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return super.prepareForFutureCommitOrPostRun(childResource);
    }

    protected final void prepareInlineRemove(String name) {
        this.prepareInlineRemove(name, name);
    }

    protected final void prepareInlineRemove(String name, String key) {
        Object childResource = this.find(key);
        if (childResource == null || ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated) {
            String errorMessage = String.format(ERROR_MESSAGE_FORMAT, this.childResourceName, name, key, "not found");
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(errorMessage));
        }
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
        super.prepareForFutureCommitOrPostRun(childResource);
    }

    protected void addChildResource(FluentModelTImpl childResource) {
        this.addChildResource(((ExternalChildResourceImpl)childResource).name(), childResource);
    }

    protected void addChildResource(String key, FluentModelTImpl childResource) {
        this.childCollection.put(key, childResource);
    }

    protected void cacheCollection() {
        this.clear();
        this.listChildResources().forEach(childResource -> this.childCollection.put(childResource.childResourceKey(), childResource));
    }

    protected Mono<Void> cacheCollectionAsync() {
        this.clear();
        return this.listChildResourcesAsync().doOnNext(childResource -> this.childCollection.put(childResource.childResourceKey(), childResource)).then();
    }

    @Override
    protected final boolean clearAfterCommit() {
        return false;
    }

    protected abstract List<FluentModelTImpl> listChildResources();

    protected abstract Flux<FluentModelTImpl> listChildResourcesAsync();

    protected abstract FluentModelTImpl newChildResource(String var1);
}

