/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.client;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.client.IJdbcRegistryClient;
import org.apache.dolphinscheduler.plugin.registry.jdbc.client.JdbcRegistryClientIdentify;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.DataType;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.ConnectionStateListener;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IJdbcRegistryServer;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.JdbcRegistryDataChangeListener;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.JdbcRegistryServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRegistryClient
implements IJdbcRegistryClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRegistryClient.class);
    private static final String DEFAULT_CLIENT_NAME = NetUtils.getHost() + "_" + OSUtils.getProcessID();
    private final JdbcRegistryClientIdentify jdbcRegistryClientIdentify;
    private final IJdbcRegistryServer jdbcRegistryServer;

    public JdbcRegistryClient(IJdbcRegistryServer jdbcRegistryServer) {
        this.jdbcRegistryServer = jdbcRegistryServer;
        this.jdbcRegistryClientIdentify = new JdbcRegistryClientIdentify(CodeGenerateUtils.genCode(), DEFAULT_CLIENT_NAME);
    }

    @Override
    public void start() {
        this.jdbcRegistryServer.registerClient(this);
    }

    @Override
    public JdbcRegistryClientIdentify getJdbcRegistryClientIdentify() {
        return this.jdbcRegistryClientIdentify;
    }

    @Override
    public void subscribeConnectionStateChange(ConnectionStateListener connectionStateListener) {
        this.jdbcRegistryServer.subscribeConnectionStateChange(connectionStateListener);
    }

    @Override
    public void subscribeJdbcRegistryDataChange(JdbcRegistryDataChangeListener jdbcRegistryDataChangeListener) {
        this.jdbcRegistryServer.subscribeJdbcRegistryDataChange(jdbcRegistryDataChangeListener);
    }

    @Override
    public Optional<JdbcRegistryDataDTO> getJdbcRegistryDataByKey(String key) {
        return this.jdbcRegistryServer.getJdbcRegistryDataByKey(key);
    }

    @Override
    public void putJdbcRegistryData(String key, String value, DataType dataType) {
        this.jdbcRegistryServer.putJdbcRegistryData(this.jdbcRegistryClientIdentify.getClientId(), key, value, dataType);
    }

    @Override
    public void deleteJdbcRegistryDataByKey(String key) {
        this.jdbcRegistryServer.deleteJdbcRegistryDataByKey(key);
    }

    @Override
    public List<JdbcRegistryDataDTO> listJdbcRegistryDataChildren(String key) {
        return this.jdbcRegistryServer.listJdbcRegistryDataChildren(key);
    }

    @Override
    public boolean existJdbcRegistryDataKey(String key) {
        return this.jdbcRegistryServer.existJdbcRegistryDataKey(key);
    }

    @Override
    public void acquireJdbcRegistryLock(String key) {
        this.jdbcRegistryServer.acquireJdbcRegistryLock(this.jdbcRegistryClientIdentify.getClientId(), key);
    }

    @Override
    public boolean acquireJdbcRegistryLock(String key, long timeout) {
        return this.jdbcRegistryServer.acquireJdbcRegistryLock(this.jdbcRegistryClientIdentify.getClientId(), key, timeout);
    }

    @Override
    public void releaseJdbcRegistryLock(String key) {
        this.jdbcRegistryServer.releaseJdbcRegistryLock(this.jdbcRegistryClientIdentify.getClientId(), key);
    }

    @Override
    public void close() {
        this.jdbcRegistryServer.deregisterClient(this);
        log.info("Closed JdbcRegistryClient: {}", (Object)this.jdbcRegistryClientIdentify);
    }

    @Override
    public boolean isConnectivity() {
        return this.jdbcRegistryServer.getServerState() == JdbcRegistryServerState.STARTED;
    }
}

