/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.CloudService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="CLOUD_TAG")
@RestController
@RequestMapping(value={"/cloud"})
public class CloudController
extends BaseController {
    @Resource
    private CloudService cloudService;

    @Operation(summary="listDataFactory", description="LIST_DATA_FACTORY")
    @GetMapping(value={"/azure/datafactory/factories"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_AZURE_DATA_FACTORY_ERROR)
    public Result listDataFactory(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<String> factoryNames = this.cloudService.listDataFactory(loginUser);
        return this.success(Status.SUCCESS.getMsg(), factoryNames);
    }

    @Operation(summary="listResourceGroup", description="LIST_RESOURCE_GROUP")
    @GetMapping(value={"/azure/datafactory/resourceGroups"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_AZURE_RESOURCE_GROUP_ERROR)
    public Result listResourceGroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<String> resourceGroupNames = this.cloudService.listResourceGroup(loginUser);
        return this.success(Status.SUCCESS.getMsg(), resourceGroupNames);
    }

    @Operation(summary="listPipeline", description="LIST_PIPELINE")
    @GetMapping(value={"/azure/datafactory/pipelines"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_AZURE_DATA_FACTORY_PIPELINE_ERROR)
    public Result listPipeline(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="factoryName") String factoryName, @RequestParam(value="resourceGroupName") String resourceGroupName) {
        List<String> pipelineNames = this.cloudService.listPipeline(loginUser, factoryName, resourceGroupName);
        return this.success(Status.SUCCESS.getMsg(), pipelineNames);
    }
}

