/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Copy;
import com.qcloud.cos.transfer.TransferManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CopyFileDemo {
    private static String secretId = System.getenv("SECRETID");
    private static String secretKey = System.getenv("SECRETKEY");
    private static String srcBucketName = "srcBucket-12500000000";
    private static String srcKey = "aaa/bbb.txt";
    private static String destBucketName = "destBucket-12500000000";
    private static String destKey = "ccc/ddd.txt";
    private static String srcRegion = "ap-guangzhou";
    private static String dstRegion = "ap-guangzhou";
    private static COSClient srcCosClient = CopyFileDemo.createCli(srcRegion);
    private static COSClient dstCosClient = CopyFileDemo.createCli(dstRegion);

    public static void main(String[] args) {
        try {
            CopyFileDemo.copySmallFileDemo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CopyFileDemo.shutdown();
        }
    }

    private static COSClient createCli(String region) {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        COSClient cosclient = new COSClient(cred, clientConfig);
        return cosclient;
    }

    private static void shutdown() {
        if (srcCosClient != null) {
            srcCosClient.shutdown();
            srcCosClient = null;
        }
        if (dstCosClient != null) {
            dstCosClient.shutdown();
            dstCosClient = null;
        }
    }

    private static void copySmallFileDemo() {
        Region srcBucketRegion = new Region(srcRegion);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        try {
            CopyObjectResult copyObjectResult = dstCosClient.copyObject(copyObjectRequest);
            String crc64 = copyObjectResult.getCrc64Ecma();
            System.out.println("succeed to copy object");
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    private static void copyBigFileDemo() {
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(dstCosClient, threadPool);
        Region srcBucketRegion = new Region(srcRegion);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        try {
            Copy copy = transferManager.copy(copyObjectRequest, srcCosClient, null);
            CopyResult copyResult = copy.waitForCopyResult();
            System.out.println("succeed to copy object");
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

