/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dns.fluent.models.ZoneProperties;
import com.azure.resourcemanager.dns.models.ZoneType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ZoneInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ZoneInner.class);
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="properties")
    private ZoneProperties innerProperties;

    public String etag() {
        return this.etag;
    }

    public ZoneInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    private ZoneProperties innerProperties() {
        return this.innerProperties;
    }

    public ZoneInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ZoneInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Long maxNumberOfRecordSets() {
        return this.innerProperties() == null ? null : this.innerProperties().maxNumberOfRecordSets();
    }

    public Long maxNumberOfRecordsPerRecordSet() {
        return this.innerProperties() == null ? null : this.innerProperties().maxNumberOfRecordsPerRecordSet();
    }

    public Long numberOfRecordSets() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfRecordSets();
    }

    public List<String> nameServers() {
        return this.innerProperties() == null ? null : this.innerProperties().nameServers();
    }

    public ZoneType zoneType() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneType();
    }

    public ZoneInner withZoneType(ZoneType zoneType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ZoneProperties();
        }
        this.innerProperties().withZoneType(zoneType);
        return this;
    }

    public List<SubResource> registrationVirtualNetworks() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationVirtualNetworks();
    }

    public ZoneInner withRegistrationVirtualNetworks(List<SubResource> registrationVirtualNetworks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ZoneProperties();
        }
        this.innerProperties().withRegistrationVirtualNetworks(registrationVirtualNetworks);
        return this;
    }

    public List<SubResource> resolutionVirtualNetworks() {
        return this.innerProperties() == null ? null : this.innerProperties().resolutionVirtualNetworks();
    }

    public ZoneInner withResolutionVirtualNetworks(List<SubResource> resolutionVirtualNetworks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ZoneProperties();
        }
        this.innerProperties().withResolutionVirtualNetworks(resolutionVirtualNetworks);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

