/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.plugin.postgresql.monitor;

import com.baomidou.mybatisplus.annotation.DbType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMetrics;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMonitor;

public class PostgresqlMonitor
implements DatabaseMonitor {
    private final DataSource dataSource;

    public PostgresqlMonitor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DatabaseMetrics getDatabaseMetrics() {
        DatabaseMetrics monitorRecord = new DatabaseMetrics();
        monitorRecord.setDate(new Date());
        monitorRecord.setState(DatabaseMetrics.DatabaseHealthStatus.YES);
        monitorRecord.setDbType(DbType.POSTGRE_SQL);
        try (Connection connection = this.dataSource.getConnection();
             Statement pstmt = connection.createStatement();){
            try (ResultSet rs1 = pstmt.executeQuery("select count(*) from pg_stat_activity;");){
                if (rs1.next()) {
                    monitorRecord.setThreadsConnections((long)rs1.getInt("count"));
                }
            }
            var7_12 = null;
            try (ResultSet rs2 = pstmt.executeQuery("show max_connections");){
                if (rs2.next()) {
                    monitorRecord.setMaxConnections((long)rs2.getInt("max_connections"));
                }
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
            var7_12 = null;
            try (ResultSet rs3 = pstmt.executeQuery("select count(*) from pg_stat_activity pg where pg.state = 'active';");){
                if (rs3.next()) {
                    monitorRecord.setThreadsRunningConnections((long)rs3.getInt("count"));
                }
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
        }
        return monitorRecord;
    }
}

