/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.security.keyvault.keys.cryptography.Aes128Cbc;
import com.azure.security.keyvault.keys.cryptography.Aes128CbcHmacSha256;
import com.azure.security.keyvault.keys.cryptography.Aes128CbcPad;
import com.azure.security.keyvault.keys.cryptography.Aes128Kw;
import com.azure.security.keyvault.keys.cryptography.Aes192Cbc;
import com.azure.security.keyvault.keys.cryptography.Aes192CbcHmacSha384;
import com.azure.security.keyvault.keys.cryptography.Aes192CbcPad;
import com.azure.security.keyvault.keys.cryptography.Aes192Kw;
import com.azure.security.keyvault.keys.cryptography.Aes256Cbc;
import com.azure.security.keyvault.keys.cryptography.Aes256CbcHmacSha512;
import com.azure.security.keyvault.keys.cryptography.Aes256CbcPad;
import com.azure.security.keyvault.keys.cryptography.Aes256Kw;
import com.azure.security.keyvault.keys.cryptography.Algorithm;
import com.azure.security.keyvault.keys.cryptography.Es256;
import com.azure.security.keyvault.keys.cryptography.Es256k;
import com.azure.security.keyvault.keys.cryptography.Es384;
import com.azure.security.keyvault.keys.cryptography.Es512;
import com.azure.security.keyvault.keys.cryptography.Rsa15;
import com.azure.security.keyvault.keys.cryptography.RsaOaep;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class AlgorithmResolver {
    static final AlgorithmResolver DEFAULT = new AlgorithmResolver();
    private final Map<String, Algorithm> algorithms = new ConcurrentHashMap<String, Algorithm>();

    AlgorithmResolver() {
    }

    public Algorithm get(String algorithmName) {
        return this.algorithms.get(algorithmName);
    }

    public void put(String algorithmName, Algorithm provider) {
        this.algorithms.put(algorithmName, provider);
    }

    public void remove(String algorithmName) {
        this.algorithms.remove(algorithmName);
    }

    static {
        DEFAULT.put("A128CBC", new Aes128Cbc());
        DEFAULT.put("A192CBC", new Aes192Cbc());
        DEFAULT.put("A256CBC", new Aes256Cbc());
        DEFAULT.put("A128CBCPAD", new Aes128CbcPad());
        DEFAULT.put("A192CBCPAD", new Aes192CbcPad());
        DEFAULT.put("A256CBCPAD", new Aes256CbcPad());
        DEFAULT.put("A128CBC-HS256", new Aes128CbcHmacSha256());
        DEFAULT.put("A192CBC-HS384", new Aes192CbcHmacSha384());
        DEFAULT.put("A256CBC-HS512", new Aes256CbcHmacSha512());
        DEFAULT.put("A128KW", new Aes128Kw());
        DEFAULT.put("A192KW", new Aes192Kw());
        DEFAULT.put("A256KW", new Aes256Kw());
        DEFAULT.put("RSA1_5", new Rsa15());
        DEFAULT.put("RSA-OAEP", new RsaOaep());
        DEFAULT.put("ES256K", new Es256k());
        DEFAULT.put("ES256", new Es256());
        DEFAULT.put("ES384", new Es384());
        DEFAULT.put("ES512", new Es512());
    }
}

