/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;

public enum PluginType {
    ALERT(1, "alert", true),
    REGISTER(2, "register", false),
    TASK(3, "task", true);

    @EnumValue
    private final int code;
    private final String desc;
    private final boolean hasUi;
    private static HashMap<Integer, PluginType> PLUGIN_TYPE_MAP;

    private PluginType(int code, String desc, boolean hasUi) {
        this.code = code;
        this.desc = desc;
        this.hasUi = hasUi;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean getHasUi() {
        return this.hasUi;
    }

    public static PluginType of(int type) {
        if (PLUGIN_TYPE_MAP.containsKey(type)) {
            return PLUGIN_TYPE_MAP.get(type);
        }
        throw new IllegalArgumentException("invalid type : " + type);
    }

    static {
        PLUGIN_TYPE_MAP = new HashMap();
        for (PluginType pluginType : PluginType.values()) {
            PLUGIN_TYPE_MAP.put(pluginType.getCode(), pluginType);
        }
    }
}

