/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.JsonPatchProcessor;
import com.flipkart.zjsonpatch.JsonPointer;
import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import com.flipkart.zjsonpatch.Operation;
import java.util.EnumSet;

class InPlaceApplyProcessor
implements JsonPatchProcessor {
    private JsonNode target;
    private EnumSet<CompatibilityFlags> flags;

    InPlaceApplyProcessor(JsonNode target) {
        this(target, CompatibilityFlags.defaults());
    }

    InPlaceApplyProcessor(JsonNode target, EnumSet<CompatibilityFlags> flags) {
        this.target = target;
        this.flags = flags;
    }

    public JsonNode result() {
        return this.target;
    }

    @Override
    public void move(JsonPointer fromPath, JsonPointer toPath) throws JsonPointerEvaluationException {
        JsonNode valueNode = fromPath.evaluate(this.target);
        this.remove(fromPath);
        this.set(toPath, valueNode, Operation.MOVE);
    }

    @Override
    public void copy(JsonPointer fromPath, JsonPointer toPath) throws JsonPointerEvaluationException {
        JsonNode valueNode = fromPath.evaluate(this.target);
        JsonNode valueToCopy = valueNode != null ? valueNode.deepCopy() : null;
        this.set(toPath, valueToCopy, Operation.COPY);
    }

    private static String show(JsonNode value) {
        if (value == null || value.isNull()) {
            return "null";
        }
        if (value.isArray()) {
            return "array";
        }
        if (value.isObject()) {
            return "object";
        }
        return "value " + value.toString();
    }

    @Override
    public void test(JsonPointer path, JsonNode value) throws JsonPointerEvaluationException {
        JsonNode valueNode = path.evaluate(this.target);
        if (!valueNode.equals((Object)value)) {
            throw new JsonPatchApplicationException("Expected " + InPlaceApplyProcessor.show(value) + " but found " + InPlaceApplyProcessor.show(valueNode), Operation.TEST, path);
        }
    }

    @Override
    public void add(JsonPointer path, JsonNode value) throws JsonPointerEvaluationException {
        this.set(path, value, Operation.ADD);
    }

    @Override
    public void replace(JsonPointer path, JsonNode value) throws JsonPointerEvaluationException {
        if (path.isRoot()) {
            this.target = value;
            return;
        }
        JsonNode parentNode = path.getParent().evaluate(this.target);
        JsonPointer.RefToken token = path.last();
        if (parentNode.isObject()) {
            if (!this.flags.contains((Object)CompatibilityFlags.ALLOW_MISSING_TARGET_OBJECT_ON_REPLACE) && !parentNode.has(token.getField())) {
                throw new JsonPatchApplicationException("Missing field \"" + token.getField() + "\"", Operation.REPLACE, path.getParent());
            }
            ((ObjectNode)parentNode).replace(token.getField(), value);
        } else if (parentNode.isArray()) {
            if (token.getIndex() >= parentNode.size()) {
                throw new JsonPatchApplicationException("Array index " + token.getIndex() + " out of bounds", Operation.REPLACE, path.getParent());
            }
            ((ArrayNode)parentNode).set(token.getIndex(), value);
        } else {
            throw new JsonPatchApplicationException("Can't reference past scalar value", Operation.REPLACE, path.getParent());
        }
    }

    @Override
    public void remove(JsonPointer path) throws JsonPointerEvaluationException {
        if (path.isRoot()) {
            throw new JsonPatchApplicationException("Cannot remove document root", Operation.REMOVE, path);
        }
        JsonNode parentNode = path.getParent().evaluate(this.target);
        JsonPointer.RefToken token = path.last();
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(token.getField());
        } else if (parentNode.isArray()) {
            if (!this.flags.contains((Object)CompatibilityFlags.REMOVE_NONE_EXISTING_ARRAY_ELEMENT) && token.getIndex() >= parentNode.size()) {
                throw new JsonPatchApplicationException("Array index " + token.getIndex() + " out of bounds", Operation.REPLACE, path.getParent());
            }
            ((ArrayNode)parentNode).remove(token.getIndex());
        } else {
            throw new JsonPatchApplicationException("Cannot reference past scalar value", Operation.REPLACE, path.getParent());
        }
    }

    private void set(JsonPointer path, JsonNode value, Operation forOp) throws JsonPointerEvaluationException {
        if (path.isRoot()) {
            this.target = value;
        } else {
            JsonNode parentNode = path.getParent().evaluate(this.target);
            if (!parentNode.isContainerNode()) {
                throw new JsonPatchApplicationException("Cannot reference past scalar value", forOp, path.getParent());
            }
            if (parentNode.isArray()) {
                this.addToArray(path, value, parentNode);
            } else {
                this.addToObject(path, parentNode, value);
            }
        }
    }

    private void addToObject(JsonPointer path, JsonNode node, JsonNode value) {
        ObjectNode target = (ObjectNode)node;
        String key = path.last().getField();
        target.set(key, value);
    }

    private void addToArray(JsonPointer path, JsonNode value, JsonNode parentNode) {
        ArrayNode target = (ArrayNode)parentNode;
        int idx = path.last().getIndex();
        if (idx == Integer.MIN_VALUE) {
            target.add(value);
        } else {
            if (idx > target.size()) {
                throw new JsonPatchApplicationException("Array index " + idx + " out of bounds", Operation.ADD, path.getParent());
            }
            target.insert(idx, value);
        }
    }
}

