/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.rpc;

import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.dolphinscheduler.extract.worker.IPhysicalTaskExecutorOperator;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskEngineDelegator;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorDispatchRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorDispatchResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorPauseRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorPauseResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorReassignMasterRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorReassignMasterResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhysicalTaskExecutorOperatorImpl
implements IPhysicalTaskExecutorOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhysicalTaskExecutorOperatorImpl.class);
    @Autowired
    private PhysicalTaskEngineDelegator physicalTaskEngineDelegator;

    public TaskExecutorDispatchResponse dispatchTask(TaskExecutorDispatchRequest taskExecutorDispatchRequest) {
        log.info("Receive TaskExecutorDispatchResponse: {}", (Object)taskExecutorDispatchRequest);
        TaskExecutionContext taskExecutionContext = taskExecutorDispatchRequest.getTaskExecutionContext();
        try {
            this.physicalTaskEngineDelegator.dispatchLogicTask(taskExecutionContext);
            log.info("Handle TaskExecutorDispatchResponse: {} success", (Object)taskExecutorDispatchRequest);
            return TaskExecutorDispatchResponse.success();
        }
        catch (Throwable throwable) {
            log.error("Handle TaskExecutorDispatchResponse: {} failed", (Object)taskExecutorDispatchRequest, (Object)throwable);
            return TaskExecutorDispatchResponse.failed((String)ExceptionUtils.getMessage((Throwable)throwable));
        }
    }

    public TaskExecutorKillResponse killTask(TaskExecutorKillRequest taskExecutorKillRequest) {
        log.info("Receive TaskExecutorKillRequest: {}", (Object)taskExecutorKillRequest);
        int taskInstanceId = taskExecutorKillRequest.getTaskInstanceId();
        try {
            this.physicalTaskEngineDelegator.killLogicTask(taskInstanceId);
            log.info("Handle TaskExecutorKillRequest: {} success", (Object)taskExecutorKillRequest);
            return TaskExecutorKillResponse.success();
        }
        catch (Throwable throwable) {
            log.error("Handle TaskExecutorKillRequest: {} failed", (Object)taskExecutorKillRequest, (Object)throwable);
            return TaskExecutorKillResponse.fail((String)ExceptionUtils.getMessage((Throwable)throwable));
        }
    }

    public TaskExecutorPauseResponse pauseTask(TaskExecutorPauseRequest taskPauseRequest) {
        log.info("Receive TaskExecutorPauseRequest: {}", (Object)taskPauseRequest);
        int taskInstanceId = taskPauseRequest.getTaskInstanceId();
        try {
            this.physicalTaskEngineDelegator.pauseLogicTask(taskInstanceId);
            log.info("Handle TaskExecutorPauseRequest: {} success", (Object)taskPauseRequest);
            return TaskExecutorPauseResponse.success();
        }
        catch (Throwable throwable) {
            log.error("Handle TaskExecutorPauseRequest: {} failed", (Object)taskPauseRequest, (Object)throwable);
            return TaskExecutorPauseResponse.fail((String)ExceptionUtils.getMessage((Throwable)throwable));
        }
    }

    public TaskExecutorReassignMasterResponse reassignWorkflowInstanceHost(TaskExecutorReassignMasterRequest taskExecutorReassignMasterRequest) {
        boolean success = this.physicalTaskEngineDelegator.reassignWorkflowInstanceHost(taskExecutorReassignMasterRequest);
        if (success) {
            return TaskExecutorReassignMasterResponse.success();
        }
        return TaskExecutorReassignMasterResponse.failed((String)"Reassign master host failed");
    }

    public void ackPhysicalTaskExecutorLifecycleEvent(ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck taskExecutorLifecycleEventAck) {
        log.info("Receive TaskExecutorLifecycleEventAck: {}", (Object)taskExecutorLifecycleEventAck);
        this.physicalTaskEngineDelegator.ackPhysicalTaskExecutorLifecycleEventACK(taskExecutorLifecycleEventAck);
    }
}

