/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.api.local;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.dolphinscheduler.plugin.storage.api.AbstractStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorageOperator
extends AbstractStorageOperator
implements Closeable,
StorageOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalStorageOperator.class);

    public LocalStorageOperator(String resourceBaseAbsolutePath) throws IOException {
        super(resourceBaseAbsolutePath);
        Path path = Paths.get(resourceBaseAbsolutePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("The base path must be a directory: " + resourceBaseAbsolutePath);
            }
        } else {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    @Override
    public void createStorageDir(String directoryAbsolutePath) {
        Path path = Paths.get(directoryAbsolutePath, new String[0]);
        if (this.exists(directoryAbsolutePath)) {
            throw new FileAlreadyExistsException("Directory already exists: " + directoryAbsolutePath);
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    @Override
    public boolean exists(String resourceAbsolutePath) {
        return Files.exists(Paths.get(resourceAbsolutePath, new String[0]), new LinkOption[0]);
    }

    @Override
    public void delete(String resourceAbsolutePath, boolean recursive) {
        if (recursive) {
            FileUtils.deleteQuietly((File)new File(resourceAbsolutePath));
        } else {
            Files.deleteIfExists(Paths.get(resourceAbsolutePath, new String[0]));
        }
    }

    @Override
    public void copy(String srcAbsolutePath, String dstAbsolutePath, boolean deleteSource, boolean overwrite) {
        if (srcAbsolutePath.equals(dstAbsolutePath)) {
            throw new IllegalArgumentException("Source path and destination path cannot be the same: " + srcAbsolutePath);
        }
        if (!this.exists(srcAbsolutePath)) {
            throw new FileNotFoundException("Source path does not exist: " + srcAbsolutePath);
        }
        if (this.exists(dstAbsolutePath)) {
            if (!overwrite) {
                throw new FileAlreadyExistsException("Destination path already exists: " + dstAbsolutePath);
            }
            this.delete(dstAbsolutePath, true);
        }
        File srcFile = new File(srcAbsolutePath);
        File dstFile = new File(dstAbsolutePath);
        if (FileUtils.isDirectory((File)srcFile, (LinkOption[])new LinkOption[0])) {
            FileUtils.copyDirectoryToDirectory((File)srcFile, (File)dstFile);
        } else {
            FileUtils.copyFile((File)srcFile, (File)dstFile);
        }
        if (deleteSource) {
            this.delete(srcAbsolutePath, true);
        }
    }

    @Override
    public void upload(String srcLocalFileAbsolutePath, String dstAbsolutePath, boolean deleteSource, boolean overwrite) {
        this.copy(srcLocalFileAbsolutePath, dstAbsolutePath, deleteSource, overwrite);
    }

    @Override
    public void download(String srcFileAbsolutePath, String dstAbsolutePath, boolean overwrite) {
        this.copy(srcFileAbsolutePath, dstAbsolutePath, false, overwrite);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> fetchFileContent(String fileAbsolutePath, int skipLineNums, int limit) {
        try (Stream<String> stream = Files.lines(Paths.get(fileAbsolutePath, new String[0])).skip(skipLineNums).limit(limit);){
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StorageEntity> listStorageEntity(String resourceAbsolutePath) {
        Path path = Paths.get(resourceAbsolutePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Lists.newArrayList((Object[])new StorageEntity[]{this.transformFileStatusToResourceMetadata(path)});
        }
        try (Stream<Path> stream = Files.list(path);){
            List<StorageEntity> list = stream.map(this::transformFileStatusToResourceMetadata).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<StorageEntity> listFileStorageEntityRecursively(String resourceAbsolutePath) {
        ArrayList<StorageEntity> result = new ArrayList<StorageEntity>();
        LinkedList<Path> foldersToFetch = new LinkedList<Path>();
        foldersToFetch.addLast(Paths.get(resourceAbsolutePath, new String[0]));
        while (!foldersToFetch.isEmpty()) {
            Path path1 = (Path)foldersToFetch.pollFirst();
            if (!Files.exists(path1, new LinkOption[0])) continue;
            Stream<Path> children = Files.list(path1);
            Throwable throwable = null;
            try {
                children.forEach(child -> {
                    if (child.toFile().isDirectory()) {
                        foldersToFetch.add((Path)child);
                    }
                    result.add(this.transformFileStatusToResourceMetadata((Path)child));
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (children == null) continue;
                if (throwable != null) {
                    try {
                        children.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                children.close();
            }
        }
        return result;
    }

    @Override
    public StorageEntity getStorageEntity(String resourceAbsolutePath) {
        return this.transformFileStatusToResourceMetadata(Paths.get(resourceAbsolutePath, new String[0]));
    }

    @Override
    public void close() {
    }

    private StorageEntity transformFileStatusToResourceMetadata(Path path) {
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        String fileAbsolutePath = path.toAbsolutePath().toString();
        ResourceMetadata resourceMetaData = this.getResourceMetaData(fileAbsolutePath);
        return StorageEntity.builder().fileName(path.getFileName().toString()).fullName(fileAbsolutePath).pfullName(resourceMetaData.getResourceParentAbsolutePath()).type(resourceMetaData.getResourceType()).isDirectory(attrs.isDirectory()).size(attrs.size()).relativePath(resourceMetaData.getResourceRelativePath()).createTime(new Date(attrs.creationTime().toMillis())).updateTime(new Date(attrs.lastModifiedTime().toMillis())).build();
    }
}

