/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedKey
extends KeyVaultKey {
    @JsonProperty(value="recoveryId")
    private String recoveryId;
    @JsonProperty(value="key")
    private JsonWebKey keyMaterial;
    private OffsetDateTime scheduledPurgeDate;
    private OffsetDateTime deletedOn;

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    @JsonProperty(value="scheduledPurgeDate")
    private void unpackScheduledPurgeDate(Long scheduledPurgeDate) {
        this.scheduledPurgeDate = OffsetDateTime.ofInstant(Instant.ofEpochMilli(scheduledPurgeDate * 1000L), ZoneOffset.UTC);
    }

    @JsonProperty(value="deletedDate")
    private void unpackDeletedDate(Long deletedDate) {
        this.deletedOn = OffsetDateTime.ofInstant(Instant.ofEpochMilli(deletedDate * 1000L), ZoneOffset.UTC);
    }

    @JsonProperty(value="key")
    private void unpackKeyMaterial(Map<String, Object> key) {
        this.keyMaterial = this.properties.createKeyMaterialFromJson(key);
    }

    @Override
    public JsonWebKey getKey() {
        return this.keyMaterial;
    }
}

