/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.manifests;

import io.kubernetes.client.spring.extended.manifests.annotation.FromYaml;
import io.kubernetes.client.util.Yaml;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.util.ReflectionUtils;
import org.yaml.snakeyaml.error.YAMLException;

public class KubernetesFromYamlProcessor
implements InstantiationAwareBeanPostProcessor,
BeanPostProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(KubernetesFromYamlProcessor.class);
    private ListableBeanFactory beanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        FromYaml fromYamlAnnotation;
        try {
            fromYamlAnnotation = (FromYaml)this.beanFactory.findAnnotationOnBean(beanName, FromYaml.class);
            if (fromYamlAnnotation != null) {
                Object loadedObj = this.loadFromYaml(fromYamlAnnotation.filePath());
                if (!bean.getClass().isAssignableFrom(loadedObj.getClass())) {
                    log.warn("Incompatible types for @FromYaml, {} cannot apply to {}", (Object)fromYamlAnnotation.filePath(), bean.getClass());
                    return bean;
                }
                return loadedObj;
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            return bean;
        }
        for (Field field : bean.getClass().getDeclaredFields()) {
            block8: {
                fromYamlAnnotation = field.getAnnotation(FromYaml.class);
                if (fromYamlAnnotation == null) continue;
                ReflectionUtils.makeAccessible((Field)field);
                try {
                    if (field.get(bean) != null) {
                    }
                    break block8;
                }
                catch (IllegalAccessException e) {
                    log.warn("Failed inject resource for @FromYaml annotated field {}", (Object)field, (Object)e);
                }
                continue;
            }
            Object loadedObj = this.loadFromYaml(fromYamlAnnotation.filePath());
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)loadedObj);
        }
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    private Object loadFromYaml(String targetFilePath) {
        Path targetPath = Paths.get(targetFilePath, new String[0]);
        if (!Files.exists(Paths.get(targetFilePath, new String[0]), new LinkOption[0])) {
            Path classPath = Paths.get(this.getClass().getClassLoader().getResource(targetFilePath).getPath(), new String[0]);
            if (Files.exists(classPath, new LinkOption[0])) {
                targetPath = classPath;
            } else {
                throw new BeanCreationException("No such file " + targetFilePath + " either on the machine or classpaths");
            }
        }
        try {
            String yamlContent = new String(Files.readAllBytes(targetPath));
            Object loadedObj = Yaml.load((String)yamlContent);
            return loadedObj;
        }
        catch (IOException e) {
            log.error("Failed reading resource for @FromYaml annotated from {}", (Object)targetFilePath, (Object)e);
            throw new BeanCreationException("Failed reading Yaml resource from file", (Throwable)e);
        }
        catch (YAMLException e) {
            log.error("Failed parsing yaml file {}", (Object)targetFilePath, (Object)e);
            throw new BeanCreationException("Failed parsing Yaml", (Throwable)e);
        }
    }
}

