/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class HDInsightStreamingActivityTypeProperties {
    @JsonProperty(value="storageLinkedServices")
    private List<LinkedServiceReference> storageLinkedServices;
    @JsonProperty(value="arguments")
    private List<Object> arguments;
    @JsonProperty(value="getDebugInfo")
    private HDInsightActivityDebugInfoOption getDebugInfo;
    @JsonProperty(value="mapper", required=true)
    private Object mapper;
    @JsonProperty(value="reducer", required=true)
    private Object reducer;
    @JsonProperty(value="input", required=true)
    private Object input;
    @JsonProperty(value="output", required=true)
    private Object output;
    @JsonProperty(value="filePaths", required=true)
    private List<Object> filePaths;
    @JsonProperty(value="fileLinkedService")
    private LinkedServiceReference fileLinkedService;
    @JsonProperty(value="combiner")
    private Object combiner;
    @JsonProperty(value="commandEnvironment")
    private List<Object> commandEnvironment;
    @JsonProperty(value="defines")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Object> defines;
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightStreamingActivityTypeProperties.class);

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightStreamingActivityTypeProperties withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public List<Object> arguments() {
        return this.arguments;
    }

    public HDInsightStreamingActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightStreamingActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object mapper() {
        return this.mapper;
    }

    public HDInsightStreamingActivityTypeProperties withMapper(Object mapper) {
        this.mapper = mapper;
        return this;
    }

    public Object reducer() {
        return this.reducer;
    }

    public HDInsightStreamingActivityTypeProperties withReducer(Object reducer) {
        this.reducer = reducer;
        return this;
    }

    public Object input() {
        return this.input;
    }

    public HDInsightStreamingActivityTypeProperties withInput(Object input) {
        this.input = input;
        return this;
    }

    public Object output() {
        return this.output;
    }

    public HDInsightStreamingActivityTypeProperties withOutput(Object output) {
        this.output = output;
        return this;
    }

    public List<Object> filePaths() {
        return this.filePaths;
    }

    public HDInsightStreamingActivityTypeProperties withFilePaths(List<Object> filePaths) {
        this.filePaths = filePaths;
        return this;
    }

    public LinkedServiceReference fileLinkedService() {
        return this.fileLinkedService;
    }

    public HDInsightStreamingActivityTypeProperties withFileLinkedService(LinkedServiceReference fileLinkedService) {
        this.fileLinkedService = fileLinkedService;
        return this;
    }

    public Object combiner() {
        return this.combiner;
    }

    public HDInsightStreamingActivityTypeProperties withCombiner(Object combiner) {
        this.combiner = combiner;
        return this;
    }

    public List<Object> commandEnvironment() {
        return this.commandEnvironment;
    }

    public HDInsightStreamingActivityTypeProperties withCommandEnvironment(List<Object> commandEnvironment) {
        this.commandEnvironment = commandEnvironment;
        return this;
    }

    public Map<String, Object> defines() {
        return this.defines;
    }

    public HDInsightStreamingActivityTypeProperties withDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    public void validate() {
        if (this.storageLinkedServices() != null) {
            this.storageLinkedServices().forEach(e -> e.validate());
        }
        if (this.mapper() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property mapper in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.reducer() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property reducer in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.input() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property input in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.output() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property output in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.filePaths() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property filePaths in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.fileLinkedService() != null) {
            this.fileLinkedService().validate();
        }
    }
}

